/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import rp.org.apache.http.HttpConnection;
import rp.org.apache.http.HttpException;
import rp.org.apache.http.HttpHost;
import rp.org.apache.http.HttpInetConnection;
import rp.org.apache.http.HttpRequest;
import rp.org.apache.http.HttpRequestInterceptor;
import rp.org.apache.http.HttpVersion;
import rp.org.apache.http.ProtocolException;
import rp.org.apache.http.ProtocolVersion;
import rp.org.apache.http.annotation.Contract;
import rp.org.apache.http.annotation.ThreadingBehavior;
import rp.org.apache.http.protocol.HttpContext;
import rp.org.apache.http.protocol.HttpCoreContext;
import rp.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

