/*
 * Copyright 2019 EPAM Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.epam.reportportal.utils.http;

import com.epam.reportportal.restendpoint.http.MultiPartRequest;
import com.epam.ta.reportportal.ws.model.Constants;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.common.net.MediaType;

import java.util.List;

import static com.google.common.io.ByteSource.wrap;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * @author <a href="mailto:ivan_budayeu@epam.com">Ivan Budayeu</a>
 */
public class HttpRequestUtils {

	private HttpRequestUtils() {
		//static only
	}

	public static MultiPartRequest buildLogMultiPartRequest(List<SaveLogRQ> rqs) {
		MultiPartRequest.Builder builder = new MultiPartRequest.Builder();

		builder.addSerializedPart(Constants.LOG_REQUEST_JSON_PART, rqs);

		for (SaveLogRQ rq : rqs) {
			final SaveLogRQ.File file = rq.getFile();
			if (null != file) {
				builder.addBinaryPart(
						Constants.LOG_REQUEST_BINARY_PART,
						file.getName(),
						isBlank(file.getContentType()) ? MediaType.OCTET_STREAM.toString() : file.getContentType(),
						wrap(file.getContent())
				);
			}
		}
		return builder.build();
	}
}
