/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.aspect;

import com.epam.reportportal.annotations.Step;
import com.epam.reportportal.aspect.StepRequestUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.util.Calendar;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nonnull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import rp.com.google.common.base.Throwables;

@Aspect
public class StepAspect {
    private static final ThreadLocal<Deque<Maybe<String>>> stepStack = ThreadLocal.withInitial(ConcurrentLinkedDeque::new);

    @Pointcut(value="@annotation(step)")
    public void withStepAnnotation(Step step) {
    }

    @Pointcut(value="execution(* *.*(..))")
    public void anyMethod() {
    }

    @Before(value="anyMethod() && withStepAnnotation(step)", argNames="joinPoint,step")
    public void startNestedStep(JoinPoint joinPoint, Step step) {
        if (!step.isIgnored()) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Deque<Maybe<String>> steps = stepStack.get();
            Maybe<String> parent = steps.peek();
            if (parent == null) {
                return;
            }
            StartTestItemRQ startStepRequest = StepRequestUtils.buildStartStepRequest(signature, step, joinPoint);
            Launch.currentLaunch().startTestItem(parent, startStepRequest);
        }
    }

    @AfterReturning(value="anyMethod() && withStepAnnotation(step)", argNames="step")
    public void finishNestedStep(Step step) {
        if (!step.isIgnored()) {
            Deque<Maybe<String>> steps = stepStack.get();
            Maybe<String> stepId = steps.peek();
            if (stepId == null) {
                return;
            }
            FinishTestItemRQ finishStepRequest = StepRequestUtils.buildFinishStepRequest(ItemStatus.PASSED, Calendar.getInstance().getTime());
            Launch.currentLaunch().finishTestItem(stepId, finishStepRequest);
        }
    }

    @AfterThrowing(value="anyMethod() && withStepAnnotation(step)", throwing="throwable", argNames="step,throwable")
    public void failedNestedStep(Step step, Throwable throwable) {
        if (!step.isIgnored()) {
            Deque<Maybe<String>> steps = stepStack.get();
            Maybe<String> stepId = steps.peek();
            if (stepId == null) {
                return;
            }
            ReportPortal.emitLog(itemUuid -> {
                SaveLogRQ rq = new SaveLogRQ();
                rq.setItemUuid(itemUuid);
                rq.setLevel("ERROR");
                rq.setLogTime(Calendar.getInstance().getTime());
                if (throwable != null) {
                    rq.setMessage(Throwables.getStackTraceAsString(throwable));
                } else {
                    rq.setMessage("Test has failed without exception");
                }
                rq.setLogTime(Calendar.getInstance().getTime());
                return rq;
            });
            FinishTestItemRQ finishStepRequest = StepRequestUtils.buildFinishStepRequest(ItemStatus.FAILED, Calendar.getInstance().getTime());
            Launch.currentLaunch().finishTestItem(stepId, finishStepRequest);
        }
    }

    public static void setParentId(@Nonnull Maybe<String> parent) {
        stepStack.get().push(parent);
    }

    public static void removeParentId(@Nonnull Maybe<String> parentUuid) {
        stepStack.get().removeLastOccurrence(parentUuid);
    }
}

