/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.restendpoint.http.IOUtils;
import java.io.InputStream;
import java.security.KeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.io.Resources;

public class SslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslUtils.class);

    public static KeyStore loadKeyStore(String keyStore, String password) {
        KeyStore keyStore2;
        InputStream is = null;
        try {
            is = Resources.asByteSource(Resources.getResource(keyStore)).openStream();
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(is, password.toCharArray());
            keyStore2 = trustStore;
        }
        catch (Exception e) {
            try {
                String error = "Unable to load trust store";
                LOGGER.error(error, (Throwable)e);
                throw new InternalReportPortalClientException(error, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(is);
        return keyStore2;
    }
}

