/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.http;

import com.epam.reportportal.restendpoint.http.MultiPartRequest;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import rp.com.google.common.io.ByteSource;
import rp.com.google.common.net.MediaType;

public class HttpRequestUtils {
    private HttpRequestUtils() {
    }

    public static MultiPartRequest buildLogMultiPartRequest(List<SaveLogRQ> rqs) {
        MultiPartRequest.Builder builder = new MultiPartRequest.Builder();
        builder.addSerializedPart("json_request_part", rqs);
        for (SaveLogRQ rq : rqs) {
            SaveLogRQ.File file = rq.getFile();
            if (null == file) continue;
            builder.addBinaryPart("binary_part", file.getName(), StringUtils.isBlank((CharSequence)file.getContentType()) ? MediaType.OCTET_STREAM.toString() : file.getContentType(), ByteSource.wrap(file.getContent()));
        }
        return builder.build();
    }
}

