/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.impl.io;

import rp.org.apache.http.HttpRequest;
import rp.org.apache.http.HttpRequestFactory;
import rp.org.apache.http.annotation.Contract;
import rp.org.apache.http.annotation.ThreadingBehavior;
import rp.org.apache.http.config.MessageConstraints;
import rp.org.apache.http.impl.DefaultHttpRequestFactory;
import rp.org.apache.http.impl.io.DefaultHttpRequestParser;
import rp.org.apache.http.io.HttpMessageParser;
import rp.org.apache.http.io.HttpMessageParserFactory;
import rp.org.apache.http.io.SessionInputBuffer;
import rp.org.apache.http.message.BasicLineParser;
import rp.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements HttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

