/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.aspect;

import com.epam.reportportal.annotations.Step;
import com.epam.reportportal.annotations.StepTemplateConfig;
import com.epam.reportportal.utils.StepTemplateUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StepNameUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepNameUtils.class);
    private static final String STEP_GROUP = "\\{([\\w$]+(\\.[\\w$]+)*)}";

    private StepNameUtils() {
    }

    @Nonnull
    static String getStepName(@Nonnull Step step, @Nonnull MethodSignature signature, @Nonnull JoinPoint joinPoint) {
        String nameTemplate = step.value();
        if (nameTemplate.trim().isEmpty()) {
            return signature.getMethod().getName();
        }
        Matcher matcher = Pattern.compile(STEP_GROUP).matcher(nameTemplate);
        Map<String, Object> parametersMap = StepNameUtils.createParamsMapping(step.templateConfig(), signature, joinPoint.getArgs());
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String templatePart = matcher.group(1);
            String replacement = StepNameUtils.getReplacement(templatePart, parametersMap, step.templateConfig());
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(replacement != null ? replacement : matcher.group(0)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    @Nonnull
    static Map<String, Object> createParamsMapping(@Nonnull StepTemplateConfig templateConfig, @Nonnull MethodSignature signature, Object ... args) {
        int paramsCount = Math.min(signature.getParameterNames().length, Optional.ofNullable(args).map(a -> ((Object[])a).length).orElse(0));
        HashMap<String, Object> paramsMapping = new HashMap<String, Object>();
        paramsMapping.put(templateConfig.methodNameTemplate(), signature.getMethod().getName());
        for (int i = 0; i < paramsCount; ++i) {
            paramsMapping.put(signature.getParameterNames()[i], args[i]);
            paramsMapping.put(Integer.toString(i), args[i]);
        }
        return paramsMapping;
    }

    @Nullable
    private static String getReplacement(@Nonnull String templatePart, @Nonnull Map<String, Object> parametersMap, @Nonnull StepTemplateConfig templateConfig) {
        String[] fields = templatePart.split("\\.");
        String variableName = fields[0];
        if (!parametersMap.containsKey(variableName)) {
            LOGGER.error("Param - " + variableName + " was not found");
            return null;
        }
        Object param = parametersMap.get(variableName);
        try {
            return StepTemplateUtils.retrieveValue(templateConfig, 1, fields, param);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Unable to parse: " + templatePart);
            return null;
        }
    }
}

