/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.listeners;

import com.epam.reportportal.service.launch.lock.LaunchIdLockMode;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerParameters
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListenerParameters.class);
    private static final String PROPERTY_WILL_BE_REMOVED = "Property '{}' will be removed in the next major version, please use '{}' instead";
    private static final int DEFAULT_REPORTING_TIMEOUT = 300;
    private static final int DEFAULT_IO_POOL_SIZE = 100;
    private static final boolean DEFAULT_ENABLE = true;
    private static final boolean DEFAULT_SKIP_ISSUE = true;
    private static final boolean DEFAULT_CONVERT_IMAGE = false;
    private static final boolean DEFAULT_RETURN = false;
    private static final boolean DEFAULT_ASYNC_REPORTING = false;
    private static final boolean DEFAULT_CALLBACK_REPORTING_ENABLED = false;
    private static final boolean DEFAULT_HTTP_LOGGING = false;
    private static final int DEFAULT_RX_BUFFER_SIZE = 128;
    private static final boolean DEFAULT_CLIENT_JOIN = true;
    private static final String DEFAULT_CLIENT_JOIN_MODE = "FILE";
    private static final String DEFAULT_LOCK_FILE_NAME = "reportportal.lock";
    private static final String DEFAULT_SYNC_FILE_NAME = "reportportal.sync";
    public static final long DEFAULT_FILE_WAIT_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(1L);
    private static final long DEFAULT_CLIENT_JOIN_TIMEOUT = TimeUnit.MINUTES.toMillis(30L);
    private static final String DEFAULT_CLIENT_JOIN_TIMEOUT_UNIT = "MILLISECONDS";
    private static final String DEFAULT_CLIENT_JOIN_LOCK_TIMEOUT_UNIT = "MILLISECONDS";
    private static final int DEFAULT_CLIENT_JOIN_LOCK_PORT = 25464;
    private static final boolean DEFAULT_TRUNCATE_ITEM_NAMES = true;
    private static final int DEFAULT_TRUNCATE_ITEM_NAMES_LIMIT = 1024;
    private static final String DEFAULT_TRUNCATE_REPLACEMENT = "...";
    private String description;
    private String apiKey;
    private String baseUrl;
    private String proxyUrl;
    private boolean httpLogging;
    private String projectName;
    private String launchName;
    private Mode launchRunningMode;
    private Set<ItemAttributesRQ> attributes;
    private Boolean enable;
    private Boolean isSkippedAnIssue;
    private Integer batchLogsSize;
    private boolean convertImage;
    private Integer reportingTimeout;
    private String keystore;
    private String keystorePassword;
    private boolean rerun;
    private String rerunOf;
    private boolean asyncReporting;
    private boolean callbackReportingEnabled;
    private Integer ioPoolSize;
    private boolean clientJoin;
    private LaunchIdLockMode clientJoinMode;
    private String lockFileName;
    private String syncFileName;
    private long lockWaitTimeout;
    private long clientJoinTimeout;
    private int lockPortNumber;
    private int rxBufferSize;
    private boolean truncateItemNames;
    private int truncateItemNamesLimit;
    private String truncateItemNamesReplacement;

    public ListenerParameters() {
        this.isSkippedAnIssue = true;
        this.batchLogsSize = 10;
        this.convertImage = false;
        this.reportingTimeout = 300;
        this.httpLogging = false;
        this.attributes = Collections.emptySet();
        this.rerun = false;
        this.asyncReporting = false;
        this.callbackReportingEnabled = false;
        this.ioPoolSize = 100;
        this.clientJoin = true;
        this.clientJoinMode = LaunchIdLockMode.valueOf(DEFAULT_CLIENT_JOIN_MODE);
        this.clientJoinTimeout = DEFAULT_CLIENT_JOIN_TIMEOUT;
        this.lockFileName = DEFAULT_LOCK_FILE_NAME;
        this.syncFileName = DEFAULT_SYNC_FILE_NAME;
        this.lockWaitTimeout = DEFAULT_FILE_WAIT_TIMEOUT_MS;
        this.rxBufferSize = 128;
        this.truncateItemNames = true;
        this.truncateItemNamesLimit = 1024;
        this.truncateItemNamesReplacement = DEFAULT_TRUNCATE_REPLACEMENT;
        this.lockPortNumber = 25464;
    }

    public ListenerParameters(PropertiesLoader properties) {
        String waitTimeoutStr;
        this.description = properties.getProperty(ListenerProperty.DESCRIPTION);
        this.apiKey = Optional.ofNullable(properties.getProperty(ListenerProperty.API_KEY, properties.getProperty(ListenerProperty.UUID))).map(String::trim).orElse(null);
        this.baseUrl = properties.getProperty(ListenerProperty.BASE_URL) != null ? properties.getProperty(ListenerProperty.BASE_URL).trim() : null;
        this.proxyUrl = properties.getProperty(ListenerProperty.HTTP_PROXY_URL);
        this.projectName = properties.getProperty(ListenerProperty.PROJECT_NAME) != null ? properties.getProperty(ListenerProperty.PROJECT_NAME).trim() : null;
        this.launchName = properties.getProperty(ListenerProperty.LAUNCH_NAME);
        this.attributes = Collections.unmodifiableSet(AttributeParser.parseAsSet(properties.getProperty(ListenerProperty.LAUNCH_ATTRIBUTES)));
        this.launchRunningMode = this.parseLaunchMode(properties.getProperty(ListenerProperty.MODE));
        this.enable = properties.getPropertyAsBoolean(ListenerProperty.ENABLE, true);
        this.isSkippedAnIssue = properties.getPropertyAsBoolean(ListenerProperty.SKIPPED_AS_ISSUE, true);
        this.batchLogsSize = properties.getPropertyAsInt(ListenerProperty.BATCH_SIZE_LOGS, 10);
        this.convertImage = properties.getPropertyAsBoolean(ListenerProperty.IS_CONVERT_IMAGE, false);
        this.reportingTimeout = properties.getPropertyAsInt(ListenerProperty.REPORTING_TIMEOUT, 300);
        this.httpLogging = properties.getPropertyAsBoolean(ListenerProperty.HTTP_LOGGING, false);
        this.keystore = properties.getProperty(ListenerProperty.KEYSTORE_RESOURCE);
        this.keystorePassword = properties.getProperty(ListenerProperty.KEYSTORE_PASSWORD);
        this.rerun = properties.getPropertyAsBoolean(ListenerProperty.RERUN, false);
        this.rerunOf = properties.getProperty(ListenerProperty.RERUN_OF);
        this.asyncReporting = properties.getPropertyAsBoolean(ListenerProperty.ASYNC_REPORTING, false);
        this.callbackReportingEnabled = properties.getPropertyAsBoolean(ListenerProperty.CALLBACK_REPORTING_ENABLED, false);
        this.ioPoolSize = properties.getPropertyAsInt(ListenerProperty.IO_POOL_SIZE, 100);
        this.clientJoin = properties.getPropertyAsBoolean(ListenerProperty.CLIENT_JOIN_MODE, true);
        this.clientJoinMode = LaunchIdLockMode.valueOf(properties.getProperty(ListenerProperty.CLIENT_JOIN_MODE_VALUE, DEFAULT_CLIENT_JOIN_MODE));
        this.clientJoinTimeout = Optional.ofNullable(properties.getProperty(ListenerProperty.CLIENT_JOIN_TIMEOUT_VALUE)).map(t -> TimeUnit.valueOf(properties.getProperty(ListenerProperty.CLIENT_JOIN_TIMEOUT_UNIT, "MILLISECONDS")).toMillis(Long.parseLong(t))).orElse(DEFAULT_CLIENT_JOIN_TIMEOUT);
        this.lockFileName = properties.getProperty(ListenerProperty.LOCK_FILE_NAME);
        if (this.lockFileName != null) {
            LOGGER.warn(PROPERTY_WILL_BE_REMOVED, (Object)ListenerProperty.LOCK_FILE_NAME.getPropertyName(), (Object)ListenerProperty.FILE_LOCK_NAME.getPropertyName());
            this.lockFileName = properties.getProperty(ListenerProperty.FILE_LOCK_NAME, this.lockFileName);
        } else {
            this.lockFileName = properties.getProperty(ListenerProperty.FILE_LOCK_NAME, DEFAULT_LOCK_FILE_NAME);
        }
        this.syncFileName = properties.getProperty(ListenerProperty.SYNC_FILE_NAME);
        if (this.syncFileName != null) {
            LOGGER.warn(PROPERTY_WILL_BE_REMOVED, (Object)ListenerProperty.SYNC_FILE_NAME.getPropertyName(), (Object)ListenerProperty.FILE_SYNC_NAME.getPropertyName());
            this.syncFileName = properties.getProperty(ListenerProperty.FILE_SYNC_NAME, this.syncFileName);
        } else {
            this.syncFileName = properties.getProperty(ListenerProperty.FILE_SYNC_NAME, DEFAULT_SYNC_FILE_NAME);
        }
        String fileWaitTimeoutStr = properties.getProperty(ListenerProperty.FILE_WAIT_TIMEOUT_MS);
        if (fileWaitTimeoutStr != null) {
            LOGGER.warn(PROPERTY_WILL_BE_REMOVED, (Object)ListenerProperty.FILE_WAIT_TIMEOUT_MS.getPropertyName(), (Object)(ListenerProperty.CLIENT_JOIN_LOCK_TIMEOUT_VALUE.getPropertyName() + "," + ListenerProperty.CLIENT_JOIN_LOCK_TIMEOUT_UNIT.getPropertyName()));
            this.lockWaitTimeout = Long.parseLong(fileWaitTimeoutStr);
        }
        if ((waitTimeoutStr = properties.getProperty(ListenerProperty.CLIENT_JOIN_LOCK_TIMEOUT_VALUE)) != null) {
            TimeUnit waitTimeUnit = TimeUnit.valueOf(properties.getProperty(ListenerProperty.CLIENT_JOIN_LOCK_TIMEOUT_UNIT, "MILLISECONDS"));
            this.lockWaitTimeout = waitTimeUnit.toMillis(Long.parseLong(waitTimeoutStr));
        }
        if (fileWaitTimeoutStr == null && waitTimeoutStr == null) {
            this.lockWaitTimeout = DEFAULT_FILE_WAIT_TIMEOUT_MS;
        }
        this.lockPortNumber = properties.getPropertyAsInt(ListenerProperty.CLIENT_JOIN_LOCK_PORT, 25464);
        this.rxBufferSize = properties.getPropertyAsInt(ListenerProperty.RX_BUFFER_SIZE, 128);
        this.truncateItemNames = properties.getPropertyAsBoolean(ListenerProperty.TRUNCATE_ITEM_NAMES, true);
        this.truncateItemNamesLimit = properties.getPropertyAsInt(ListenerProperty.TRUNCATE_ITEM_LIMIT, 1024);
        this.truncateItemNamesReplacement = properties.getProperty(ListenerProperty.TRUNCATE_ITEM_REPLACEMENT, DEFAULT_TRUNCATE_REPLACEMENT);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getLaunchName() {
        return this.launchName;
    }

    public void setLaunchName(String launchName) {
        this.launchName = launchName;
    }

    public Mode getLaunchRunningMode() {
        return this.launchRunningMode;
    }

    public void setLaunchRunningMode(Mode launchRunningMode) {
        this.launchRunningMode = launchRunningMode;
    }

    public Set<ItemAttributesRQ> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    public void setAttributes(Set<ItemAttributesRQ> attributes) {
        this.attributes = new HashSet<ItemAttributesRQ>(attributes);
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getSkippedAnIssue() {
        return this.isSkippedAnIssue;
    }

    public void setSkippedAnIssue(Boolean skippedAnIssue) {
        this.isSkippedAnIssue = skippedAnIssue;
    }

    public Integer getBatchLogsSize() {
        return this.batchLogsSize;
    }

    public void setBatchLogsSize(Integer batchLogsSize) {
        this.batchLogsSize = batchLogsSize;
    }

    public boolean isConvertImage() {
        return this.convertImage;
    }

    public void setConvertImage(boolean convertImage) {
        this.convertImage = convertImage;
    }

    public Integer getReportingTimeout() {
        return this.reportingTimeout;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setReportingTimeout(Integer reportingTimeout) {
        this.reportingTimeout = reportingTimeout;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public boolean isAsyncReporting() {
        return this.asyncReporting;
    }

    public void setAsyncReporting(boolean asyncReporting) {
        this.asyncReporting = asyncReporting;
    }

    public boolean isCallbackReportingEnabled() {
        return this.callbackReportingEnabled;
    }

    public void setCallbackReportingEnabled(boolean callbackReportingEnabled) {
        this.callbackReportingEnabled = callbackReportingEnabled;
    }

    public void setRerun(boolean rerun) {
        this.rerun = rerun;
    }

    public String getRerunOf() {
        return this.rerunOf;
    }

    public void setRerunOf(String rerunOf) {
        this.rerunOf = rerunOf;
    }

    public Integer getIoPoolSize() {
        return this.ioPoolSize;
    }

    public void setIoPoolSize(Integer ioPoolSize) {
        this.ioPoolSize = ioPoolSize;
    }

    public boolean getClientJoin() {
        return this.clientJoin;
    }

    public void setClientJoin(boolean mode) {
        this.clientJoin = mode;
    }

    public LaunchIdLockMode getClientJoinMode() {
        return this.clientJoinMode;
    }

    public void setClientJoinMode(LaunchIdLockMode clientJoinMode) {
        this.clientJoinMode = clientJoinMode;
    }

    public String getLockFileName() {
        return this.lockFileName;
    }

    public void setLockFileName(String fileName) {
        this.lockFileName = fileName;
    }

    public String getSyncFileName() {
        return this.syncFileName;
    }

    public void setSyncFileName(String fileName) {
        this.syncFileName = fileName;
    }

    public long getClientJoinTimeout() {
        return this.clientJoinTimeout;
    }

    public void setClientJoinTimeout(long clientJoinTimeout) {
        this.clientJoinTimeout = clientJoinTimeout;
    }

    public long getLockWaitTimeout() {
        return this.lockWaitTimeout;
    }

    public void setLockWaitTimeout(long timeout) {
        this.lockWaitTimeout = timeout;
    }

    public int getLockPortNumber() {
        return this.lockPortNumber;
    }

    public void setLockPortNumber(int lockPortNumber) {
        this.lockPortNumber = lockPortNumber;
    }

    public boolean isHttpLogging() {
        return this.httpLogging;
    }

    public void setHttpLogging(boolean httpLogging) {
        this.httpLogging = httpLogging;
    }

    public int getRxBufferSize() {
        return Optional.ofNullable(System.getProperty("rx2.buffer-size")).map(Integer::valueOf).map(s -> Math.max(1, s)).orElse(this.rxBufferSize);
    }

    public void setRxBufferSize(int size) {
        this.rxBufferSize = size;
    }

    public boolean isTruncateItemNames() {
        return this.truncateItemNames;
    }

    public void setTruncateItemNames(boolean truncate) {
        this.truncateItemNames = truncate;
    }

    public int getTruncateItemNamesLimit() {
        return this.truncateItemNamesLimit;
    }

    public void setTruncateItemNamesLimit(int limit) {
        this.truncateItemNamesLimit = limit;
    }

    public String getTruncateItemNamesReplacement() {
        return this.truncateItemNamesReplacement;
    }

    public void setTruncateItemNamesReplacement(String replacement) {
        this.truncateItemNamesReplacement = replacement;
    }

    @VisibleForTesting
    Mode parseLaunchMode(String mode) {
        return Mode.isExists((String)mode) ? Mode.valueOf((String)mode.toUpperCase()) : Mode.DEFAULT;
    }

    public ListenerParameters clone() {
        ListenerParameters clonedParent;
        try {
            clonedParent = (ListenerParameters)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            clonedParent = new ListenerParameters();
        }
        ListenerParameters clone = clonedParent;
        Arrays.stream(this.getClass().getDeclaredFields()).forEach(f -> {
            if (Modifier.isFinal(f.getModifiers())) {
                return;
            }
            try {
                f.set(clone, f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        });
        return clone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ListenerParameters{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(", apiKey='").append(this.apiKey).append('\'');
        sb.append(", baseUrl='").append(this.baseUrl).append('\'');
        sb.append(", proxyUrl='").append(this.proxyUrl).append('\'');
        sb.append(", httpLogging='").append(this.httpLogging).append('\'');
        sb.append(", projectName='").append(this.projectName).append('\'');
        sb.append(", launchName='").append(this.launchName).append('\'');
        sb.append(", launchRunningMode=").append(this.launchRunningMode);
        sb.append(", attributes=").append(this.attributes);
        sb.append(", enable=").append(this.enable);
        sb.append(", isSkippedAnIssue=").append(this.isSkippedAnIssue);
        sb.append(", batchLogsSize=").append(this.batchLogsSize);
        sb.append(", convertImage=").append(this.convertImage);
        sb.append(", reportingTimeout=").append(this.reportingTimeout);
        sb.append(", keystore='").append(this.keystore).append('\'');
        sb.append(", keystorePassword='").append(this.keystorePassword).append('\'');
        sb.append(", rerun=").append(this.rerun);
        sb.append(", rerunOf='").append(this.rerunOf).append('\'');
        sb.append(", asyncReporting=").append(this.asyncReporting);
        sb.append(", ioPoolSize=").append(this.ioPoolSize);
        sb.append(", callbackReportingEnabled=").append(this.callbackReportingEnabled);
        sb.append(", clientJoin=").append(this.clientJoin);
        sb.append(", clientJoinMode=").append((String)Optional.ofNullable(this.clientJoinMode).map(Enum::name).orElse(null));
        sb.append(", clientJoinTimeout=").append(this.clientJoinTimeout);
        sb.append(", lockFileName=").append(this.lockFileName);
        sb.append(", syncFileName=").append(this.syncFileName);
        sb.append(", lockWaitTimeout=").append(this.lockWaitTimeout);
        sb.append(", lockPortNumber=").append(this.lockPortNumber);
        sb.append(", rxBufferSize=").append(this.rxBufferSize);
        sb.append('}');
        return sb.toString();
    }
}

