/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.LoggingCallback;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.reportportal.utils.files.ImageConverter;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.common.io.ByteSource;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.internal.operators.flowable.FlowableFromObservable;
import io.reactivex.subjects.PublishSubject;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Function;

public class LoggingContext {
    public static final int DEFAULT_LOG_BATCH_SIZE = 10;
    @Deprecated
    public static final int DEFAULT_BUFFER_SIZE = 10;
    static final ThreadLocal<Deque<LoggingContext>> CONTEXT_THREAD_LOCAL = ThreadLocal.withInitial(ArrayDeque::new);
    private final PublishSubject<Maybe<SaveLogRQ>> emitter;
    private final Maybe<String> launchUuid;
    private final Maybe<String> itemUuid;
    private final boolean convertImages;

    public static LoggingContext init(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler, ListenerParameters parameters) {
        LoggingContext context = new LoggingContext(launchUuid, itemUuid, client, scheduler, parameters);
        CONTEXT_THREAD_LOCAL.get().push(context);
        return context;
    }

    public static LoggingContext init(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler) {
        return LoggingContext.init(launchUuid, itemUuid, client, scheduler, 10, false);
    }

    public static LoggingContext init(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler, int batchLogsSize, boolean convertImages) {
        ListenerParameters params = new ListenerParameters();
        params.setBatchLogsSize(batchLogsSize);
        params.setConvertImage(convertImages);
        LoggingContext context = new LoggingContext(launchUuid, itemUuid, client, scheduler, params);
        CONTEXT_THREAD_LOCAL.get().push(context);
        return context;
    }

    public static Completable complete() {
        LoggingContext loggingContext = CONTEXT_THREAD_LOCAL.get().poll();
        if (null != loggingContext) {
            return loggingContext.completed();
        }
        return Maybe.empty().ignoreElement();
    }

    LoggingContext(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler, ListenerParameters parameters) {
        this.launchUuid = launchUuid;
        this.itemUuid = itemUuid;
        this.emitter = PublishSubject.create();
        this.convertImages = parameters.isConvertImage();
        new FlowableFromObservable(this.emitter).flatMap(Maybe::toFlowable).buffer(parameters.getBatchLogsSize().intValue()).flatMap(rqs -> client.log(HttpRequestUtils.buildLogMultiPartRequest(rqs)).toFlowable()).doOnError(LoggingCallback.LOG_ERROR).observeOn(scheduler).onBackpressureBuffer(parameters.getRxBufferSize(), false, true).subscribe(SubscriptionUtils.logFlowableResults("Logging context"));
    }

    private SaveLogRQ prepareRequest(String launchId, String itemId, Function<String, SaveLogRQ> logSupplier) throws IOException {
        SaveLogRQ rq = logSupplier.apply(itemId);
        rq.setLaunchUuid(launchId);
        SaveLogRQ.File file = rq.getFile();
        if (this.convertImages && null != file && ImageConverter.isImage(file.getContentType())) {
            TypeAwareByteSource source = ImageConverter.convert(ByteSource.wrap((byte[])file.getContent()));
            file.setContent(source.read());
            file.setContentType(source.getMediaType());
        }
        return rq;
    }

    public void emit(Function<String, SaveLogRQ> logSupplier) {
        this.emitter.onNext((Object)this.launchUuid.zipWith(this.itemUuid, (launchId, itemId) -> this.prepareRequest((String)launchId, (String)itemId, logSupplier)));
    }

    public void emit(Maybe<String> logItemUuid, Function<String, SaveLogRQ> logSupplier) {
        this.emitter.onNext((Object)this.launchUuid.zipWith(logItemUuid, (launchId, itemId) -> this.prepareRequest((String)launchId, (String)itemId, logSupplier)));
    }

    public Completable completed() {
        this.emitter.onComplete();
        return this.emitter.ignoreElements();
    }
}

