/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.statistics;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.statistics.Statistics;
import com.epam.reportportal.service.statistics.StatisticsApiClient;
import com.epam.reportportal.service.statistics.item.StatisticsItem;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class StatisticsClient
implements Statistics {
    private static final String BASE_URL = "https://www.google-analytics.com/";
    private static final String USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36";
    private static final AtomicLong THREAD_COUNTER = new AtomicLong();
    private static final ThreadFactory THREAD_FACTORY = r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("rp-stat-io-" + THREAD_COUNTER.incrementAndGet());
        return t;
    };
    private final StatisticsApiClient client;
    private final String measurementId;
    private final String apiSecret;
    private OkHttpClient httpClient;
    private ExecutorService executor;

    private static OkHttpClient buildHttpClient(ListenerParameters parameters) {
        OkHttpClient.Builder okHttpClient = new OkHttpClient.Builder();
        String proxyStr = parameters.getProxyUrl();
        if (StringUtils.isNotBlank((CharSequence)proxyStr)) {
            try {
                URL proxyUrl = new URL(proxyStr);
                String host = proxyUrl.getHost();
                int port = proxyUrl.getPort();
                InetSocketAddress address = InetSocketAddress.createUnresolved(host, port >= 0 ? port : proxyUrl.getDefaultPort());
                okHttpClient.proxy(new Proxy(Proxy.Type.HTTP, address));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        okHttpClient.retryOnConnectionFailure(true);
        return okHttpClient.build();
    }

    private static StatisticsApiClient buildClient(OkHttpClient httpClient, Scheduler scheduler) {
        RxJava2CallAdapterFactory rxFactory = RxJava2CallAdapterFactory.createWithScheduler((Scheduler)scheduler);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)rxFactory).client(httpClient).build();
        return (StatisticsApiClient)retrofit.create(StatisticsApiClient.class);
    }

    public StatisticsClient(String measurementId, String apiSecret, ListenerParameters parameters) {
        this.measurementId = measurementId;
        this.apiSecret = apiSecret;
        this.executor = Executors.newSingleThreadExecutor(THREAD_FACTORY);
        this.httpClient = StatisticsClient.buildHttpClient(parameters);
        this.client = StatisticsClient.buildClient(this.httpClient, Schedulers.from((Executor)this.executor));
    }

    public StatisticsClient(String measurementId, String apiSecret, StatisticsApiClient statisticsApiClient) {
        this.measurementId = measurementId;
        this.apiSecret = apiSecret;
        this.client = statisticsApiClient;
    }

    @Override
    public Maybe<Response<ResponseBody>> send(StatisticsItem item) {
        return this.client.send(USER_AGENT, this.measurementId, this.apiSecret, item);
    }

    @Override
    public void close() {
        Optional.ofNullable(this.httpClient).ifPresent(c -> {
            ExecutorService e = c.dispatcher().executorService();
            e.shutdown();
            try {
                if (!e.awaitTermination(10L, TimeUnit.SECONDS)) {
                    e.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            c.connectionPool().evictAll();
        });
        this.httpClient = null;
        Optional.ofNullable(this.executor).ifPresent(ExecutorService::shutdownNow);
        this.executor = null;
    }
}

