/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.http;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ContentType {
    private static final Pattern HTTP_HEADER_DELIMITER_PATTERN = Pattern.compile("[=;,]");
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String IMAGE_BMP = "image/bmp";
    public static final String IMAGE_GIF = "image/gif";
    public static final String IMAGE_JPEG = "image/jpeg";
    public static final String IMAGE_PNG = "image/png";
    public static final String IMAGE_TIFF = "image/tiff";
    public static final String IMAGE_WEBP = "image/webp";
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_SOAP_XML = "application/soap+xml";
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final String APPLICATION_XML = "application/xml";
    public static final String IMAGE_SVG = "image/svg+xml";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_XML = "text/xml";
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static final String MULTIPART_DIGEST = "multipart/digest";
    public static final String MULTIPART_PARALLEL = "multipart/parallel";

    private ContentType() {
        throw new RuntimeException("No instances should exist for the class!");
    }

    @Nullable
    public static String parse(@Nullable String contentType) {
        if (contentType == null || contentType.trim().isEmpty()) {
            return null;
        }
        String trimmed = contentType.trim();
        Matcher m = HTTP_HEADER_DELIMITER_PATTERN.matcher(trimmed);
        String mimeType = m.find() ? trimmed.substring(0, m.start()) : trimmed;
        return mimeType.isEmpty() ? null : mimeType;
    }
}

