/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.markdown;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class MarkdownUtils {
    public static final String MARKDOWN_MODE = "!!!MARKDOWN_MODE!!!";
    private static final char NEW_LINE = '\n';
    public static final String ONE_SPACE = "\u00a0";
    public static final String TABLE_INDENT = "\u00a0\u00a0\u00a0\u00a0";
    public static final String TABLE_COLUMN_SEPARATOR = "|";
    public static final String TABLE_ROW_SEPARATOR = "-";

    public static String asMarkdown(String message) {
        return MARKDOWN_MODE.concat(message);
    }

    public static String asCode(String language, String script) {
        return MarkdownUtils.asMarkdown("```" + Optional.ofNullable(language).orElse("") + '\n' + script + '\n' + "```");
    }

    @Nonnull
    public static String formatDataTable(@Nonnull List<List<String>> table) {
        StringBuilder result = new StringBuilder();
        int tableLength = table.stream().mapToInt(List::size).max().orElse(-1);
        List iterList = table.stream().map(List::iterator).collect(Collectors.toList());
        List colSizes = IntStream.range(0, tableLength).mapToObj(n -> iterList.stream().filter(Iterator::hasNext).map(Iterator::next).collect(Collectors.toList())).map(col -> col.stream().mapToInt(String::length).max().orElse(0)).collect(Collectors.toList());
        boolean header = true;
        for (List<String> row : table) {
            int i;
            result.append(TABLE_INDENT).append(TABLE_COLUMN_SEPARATOR);
            for (i = 0; i < row.size(); ++i) {
                String cell = row.get(i);
                int maxSize = (Integer)colSizes.get(i) - cell.length() + 2;
                int lSpace = maxSize / 2;
                int rSpace = maxSize - lSpace;
                IntStream.range(0, lSpace).forEach(j -> result.append(ONE_SPACE));
                result.append(cell);
                IntStream.range(0, rSpace).forEach(j -> result.append(ONE_SPACE));
                result.append(TABLE_COLUMN_SEPARATOR);
            }
            if (header) {
                header = false;
                result.append('\n');
                result.append(TABLE_INDENT).append(TABLE_COLUMN_SEPARATOR);
                for (i = 0; i < row.size(); ++i) {
                    int maxSize = (Integer)colSizes.get(i) + 2;
                    IntStream.range(0, maxSize).forEach(j -> result.append(TABLE_ROW_SEPARATOR));
                    result.append(TABLE_COLUMN_SEPARATOR);
                }
            }
            result.append('\n');
        }
        return result.toString().trim();
    }
}

