/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.BearerAuthInterceptor;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LaunchIdLock;
import com.epam.reportportal.service.LaunchImpl;
import com.epam.reportportal.service.LaunchLoggingContext;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.PathParamInterceptor;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.ReportPortalClientV2;
import com.epam.reportportal.service.launch.PrimaryLaunch;
import com.epam.reportportal.service.launch.SecondaryLaunch;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.reportportal.utils.ObjectUtils;
import com.epam.reportportal.utils.SslUtils;
import com.epam.reportportal.utils.files.Utils;
import com.epam.reportportal.utils.http.ClientUtils;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class ReportPortal {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortal.class);
    private final ListenerParameters parameters;
    private final LaunchIdLock launchIdLock;
    private final ReportPortalClient rpClient;
    private final ExecutorService executor;

    ReportPortal(@Nullable ReportPortalClient rpClient, @Nonnull ExecutorService executor, @Nonnull ListenerParameters parameters, @Nullable LaunchIdLock launchIdLock) {
        this.rpClient = rpClient;
        this.executor = executor;
        this.parameters = Objects.requireNonNull(parameters);
        this.launchIdLock = launchIdLock;
    }

    @Nonnull
    public Launch newLaunch(@Nonnull StartLaunchRQ rq) {
        if (BooleanUtils.isNotTrue((Boolean)this.parameters.getEnable()) || this.rpClient == null) {
            return Launch.NOOP_LAUNCH;
        }
        if (StringUtils.isNotBlank((CharSequence)this.parameters.getLaunchUuid())) {
            return new LaunchImpl(this.rpClient, this.parameters, (Maybe<String>)Maybe.just((Object)this.parameters.getLaunchUuid()), this.executor);
        }
        if (this.launchIdLock == null) {
            return new LaunchImpl(this.rpClient, this.parameters, rq, this.executor);
        }
        String instanceUuid = UUID.randomUUID().toString();
        String uuid = this.launchIdLock.obtainLaunchUuid(instanceUuid);
        if (uuid == null) {
            return new LaunchImpl(this.rpClient, this.parameters, rq, this.executor);
        }
        if (instanceUuid.equals(uuid)) {
            StartLaunchRQ rqCopy = ObjectUtils.clonePojo(rq, StartLaunchRQ.class);
            rqCopy.setUuid(uuid);
            return new PrimaryLaunch(this.rpClient, this.parameters, rqCopy, this.executor, this.launchIdLock, instanceUuid);
        }
        Maybe launch = Maybe.create(emitter -> {
            emitter.onSuccess((Object)uuid);
            emitter.onComplete();
        });
        return new SecondaryLaunch(this.rpClient, this.parameters, (Maybe<String>)launch, this.executor, this.launchIdLock, instanceUuid);
    }

    @Nonnull
    public Launch withLaunch(@Nonnull Maybe<String> launchUuid) {
        return Optional.ofNullable(this.rpClient).map(c -> new LaunchImpl((ReportPortalClient)c, this.parameters, launchUuid, this.executor)).orElse(Launch.NOOP_LAUNCH);
    }

    @Nonnull
    public ListenerParameters getParameters() {
        return this.parameters;
    }

    @Nullable
    public ReportPortalClient getClient() {
        return this.rpClient;
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static LaunchIdLock getLaunchLock(ListenerParameters parameters) {
        return parameters.getClientJoin() ? parameters.getClientJoinMode().getInstance(parameters) : null;
    }

    @Nonnull
    public static ReportPortal create(ReportPortalClient client, ListenerParameters params) {
        return ReportPortal.create(client, params, ReportPortal.buildExecutorService(params));
    }

    @Nonnull
    public static ReportPortal create(@Nonnull ReportPortalClient client, @Nonnull ListenerParameters params, @Nonnull ExecutorService executor) {
        return new ReportPortal(client, executor, params, ReportPortal.getLaunchLock(params));
    }

    public static boolean emitLog(Function<String, SaveLogRQ> logSupplier) {
        LoggingContext loggingContext = LoggingContext.context();
        if (null != loggingContext) {
            loggingContext.emit(logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLaunchLog(Function<String, SaveLogRQ> logSupplier) {
        LaunchLoggingContext launchLoggingContext = LaunchLoggingContext.context("default");
        if (null != launchLoggingContext) {
            launchLoggingContext.emit(logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLog(Maybe<String> itemUuid, Function<String, SaveLogRQ> logSupplier) {
        LoggingContext loggingContext = LoggingContext.context();
        if (null != loggingContext) {
            loggingContext.emit(itemUuid, logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLog(String message, String level, Date time) {
        return ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLevel(level);
            rq.setLogTime(time);
            rq.setItemUuid(itemUuid);
            rq.setMessage(message);
            return rq;
        });
    }

    public static boolean emitLaunchLog(String message, String level, Date time) {
        return ReportPortal.emitLaunchLog(launchUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLevel(level);
            rq.setLogTime(time);
            rq.setLaunchUuid(launchUuid);
            rq.setMessage(message);
            return rq;
        });
    }

    private static void fillSaveLogRQ(SaveLogRQ rq, String message, String level, Date time, File file) {
        rq.setMessage(message);
        rq.setLevel(level);
        rq.setLogTime(time);
        try {
            SaveLogRQ.File f = new SaveLogRQ.File();
            f.setContentType(MimeTypeDetector.detect(file));
            f.setContent(Utils.readFileToBytes(file));
            f.setName(UUID.randomUUID().toString());
            rq.setFile(f);
        }
        catch (IOException e) {
            LOGGER.error("Cannot send file to ReportPortal", (Throwable)e);
        }
    }

    public static boolean emitLog(String message, String level, Date time, File file) {
        return ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid(itemUuid);
            ReportPortal.fillSaveLogRQ(rq, message, level, time, file);
            return rq;
        });
    }

    public static boolean emitLaunchLog(String message, String level, Date time, File file) {
        return ReportPortal.emitLaunchLog(launchUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLaunchUuid(launchUuid);
            ReportPortal.fillSaveLogRQ(rq, message, level, time, file);
            return rq;
        });
    }

    private static void fillSaveLogRQ(SaveLogRQ rq, String level, Date time, ReportPortalMessage message) {
        rq.setLevel(level);
        rq.setLogTime(time);
        rq.setMessage(message.getMessage());
        try {
            TypeAwareByteSource data = message.getData();
            SaveLogRQ.File file = new SaveLogRQ.File();
            file.setContent(data.read());
            file.setContentType(data.getMediaType());
            file.setName(UUID.randomUUID().toString());
            rq.setFile(file);
        }
        catch (Exception e) {
            LOGGER.error("Cannot send file to ReportPortal", (Throwable)e);
        }
    }

    public static boolean emitLog(ReportPortalMessage message, String level, Date time) {
        return ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid(itemUuid);
            ReportPortal.fillSaveLogRQ(rq, level, time, message);
            return rq;
        });
    }

    public static boolean emitLaunchLog(ReportPortalMessage message, String level, Date time) {
        return ReportPortal.emitLaunchLog(launchUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLaunchUuid(launchUuid);
            ReportPortal.fillSaveLogRQ(rq, level, time, message);
            return rq;
        });
    }

    public static void sendStackTraceToRP(Throwable cause) {
        ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid(itemUuid);
            rq.setLevel("ERROR");
            rq.setLogTime(Calendar.getInstance().getTime());
            if (cause != null) {
                rq.setMessage(ExceptionUtils.getStackTrace((Throwable)cause));
            } else {
                rq.setMessage("Test has failed without exception");
            }
            rq.setLogTime(Calendar.getInstance().getTime());
            return rq;
        });
    }

    private static ExecutorService buildExecutorService(ListenerParameters params) {
        AtomicLong threadCounter = new AtomicLong();
        ThreadFactory threadFactory = r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("rp-io-" + threadCounter.incrementAndGet());
            return t;
        };
        return Executors.newFixedThreadPool(params.getIoPoolSize(), threadFactory);
    }

    public static class Builder {
        static final String API_PATH = "api/";
        private static final String HTTPS = "https";
        private OkHttpClient.Builder httpClient;
        private ListenerParameters parameters;
        private ExecutorService executor;

        public Builder withHttpClient(OkHttpClient.Builder client) {
            this.httpClient = client;
            return this;
        }

        public Builder withParameters(ListenerParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder withExecutorService(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public ReportPortal build() {
            ListenerParameters params = Optional.ofNullable(this.parameters).orElse(new ListenerParameters(this.defaultPropertiesLoader()));
            ExecutorService executorService = this.executor == null ? this.buildExecutorService(params) : this.executor;
            Class clientType = params.isAsyncReporting() ? ReportPortalClientV2.class : ReportPortalClient.class;
            return new ReportPortal(this.buildClient(clientType, params, executorService), executorService, params, this.buildLaunchLock(params));
        }

        public <T extends ReportPortalClient> T buildClient(@Nonnull Class<T> clientType, @Nonnull ListenerParameters params) {
            return this.buildClient(clientType, params, this.buildExecutorService(params));
        }

        public <T extends ReportPortalClient> T buildClient(@Nonnull Class<T> clientType, @Nonnull ListenerParameters params, @Nonnull ExecutorService executor) {
            OkHttpClient client = Optional.ofNullable(this.httpClient).map(c -> c.addInterceptor((Interceptor)new BearerAuthInterceptor(params.getApiKey())).build()).orElseGet(() -> this.defaultClient(params));
            return (T)((ReportPortalClient)Optional.ofNullable(client).map(c -> (ReportPortalClient)this.buildRestEndpoint(params, (OkHttpClient)c, executor).create(clientType)).orElse(null));
        }

        protected Retrofit buildRestEndpoint(@Nonnull ListenerParameters parameters, @Nonnull OkHttpClient client) {
            return this.buildRestEndpoint(parameters, client, this.buildExecutorService(parameters));
        }

        protected Retrofit buildRestEndpoint(@Nonnull ListenerParameters parameters, @Nonnull OkHttpClient client, @Nonnull ExecutorService executor) {
            String baseUrl = (parameters.getBaseUrl().endsWith("/") ? parameters.getBaseUrl() : parameters.getBaseUrl() + "/") + API_PATH;
            Retrofit.Builder builder = new Retrofit.Builder().client(client);
            try {
                builder.baseUrl(baseUrl);
            }
            catch (NoSuchMethodError e) {
                throw new InternalReportPortalClientException("Unable to initialize OkHttp client. ReportPortal client supports OkHttp version 3.11.0 as minimum.\nPlease update OkHttp dependency.\nBesides this usually happens due to old selenium-java version (it overrides our dependency), please use selenium-java 3.141.0 as minimum.", e);
            }
            return builder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createWithScheduler((Scheduler)Schedulers.from((Executor)executor))).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)HttpRequestUtils.MAPPER)).build();
        }

        @Nullable
        protected OkHttpClient defaultClient(@Nonnull ListenerParameters parameters) {
            URL baseUrl;
            String baseUrlStr = parameters.getBaseUrl();
            if (baseUrlStr == null) {
                LOGGER.warn("Base url for ReportPortal server is not set!");
                return null;
            }
            try {
                baseUrl = new URL(baseUrlStr);
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Unable to parse ReportPortal URL", (Throwable)e);
                return null;
            }
            String keyStore = parameters.getKeystore();
            String keyStorePassword = parameters.getKeystorePassword();
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (HTTPS.equals(baseUrl.getProtocol()) && keyStore != null) {
                if (null == keyStorePassword) {
                    String error = "You should provide keystore password parameter [" + (Object)((Object)ListenerProperty.KEYSTORE_PASSWORD) + "] if you use HTTPS protocol";
                    LOGGER.error(error);
                    throw new InternalReportPortalClientException(error);
                }
                try {
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(SslUtils.loadKeyStore(keyStore, keyStorePassword));
                    TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                    X509TrustManager trustManager = (X509TrustManager)Optional.ofNullable(trustManagers).flatMap(managers -> Arrays.stream(managers).filter(m -> m instanceof X509TrustManager).findAny()).orElseThrow(() -> new InternalReportPortalClientException("Unable to find X509 trust manager, managers:" + Arrays.toString(trustManagers)));
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, new TrustManager[]{trustManager}, null);
                    SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                    builder.sslSocketFactory(sslSocketFactory, trustManager);
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                    String error = "Unable to load trust store";
                    LOGGER.error(error, (Throwable)e);
                    throw new InternalReportPortalClientException(error, e);
                }
            }
            ClientUtils.setupProxy(builder, parameters);
            builder.addInterceptor((Interceptor)new BearerAuthInterceptor(parameters.getApiKey()));
            builder.addInterceptor((Interceptor)new PathParamInterceptor("projectName", parameters.getProjectName()));
            if (parameters.isHttpLogging()) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BODY);
                builder.addInterceptor((Interceptor)logging);
            }
            Optional.ofNullable(parameters.getHttpCallTimeout()).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).callTimeout(arg_0));
            Optional.ofNullable(parameters.getHttpConnectTimeout()).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).connectTimeout(arg_0));
            Optional.ofNullable(parameters.getHttpReadTimeout()).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).readTimeout(arg_0));
            Optional.ofNullable(parameters.getHttpWriteTimeout()).ifPresent(arg_0 -> ((OkHttpClient.Builder)builder).writeTimeout(arg_0));
            builder.retryOnConnectionFailure(true).cookieJar(new CookieJar(){
                private final Map<String, CopyOnWriteArrayList<Cookie>> STORAGE = new ConcurrentHashMap<String, CopyOnWriteArrayList<Cookie>>();

                public void saveFromResponse(@Nonnull HttpUrl url, @Nonnull List<Cookie> cookies) {
                    this.STORAGE.computeIfAbsent(url.url().getHost(), u -> new CopyOnWriteArrayList()).addAll(cookies);
                }

                @Nonnull
                public List<Cookie> loadForRequest(@Nonnull HttpUrl url) {
                    return this.STORAGE.computeIfAbsent(url.url().getHost(), u -> new CopyOnWriteArrayList());
                }
            });
            return builder.build();
        }

        @Deprecated
        protected LaunchIdLock buildLockFile(ListenerParameters parameters) {
            return this.buildLaunchLock(parameters);
        }

        protected LaunchIdLock buildLaunchLock(ListenerParameters parameters) {
            return ReportPortal.getLaunchLock(parameters);
        }

        protected PropertiesLoader defaultPropertiesLoader() {
            return PropertiesLoader.load();
        }

        protected ExecutorService buildExecutorService(ListenerParameters params) {
            return ReportPortal.buildExecutorService(params);
        }
    }
}

