/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.utils.files.ByteSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MimeTypeDetector {
    private static final String UNKNOWN_TYPE = "application/octet-stream";
    private static final String EXTENSION_DELIMITER = ".";
    private static final Map<String, String> ADDITIONAL_EXTENSION_MAPPING = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(".properties", "text/plain");
        }
    });

    private MimeTypeDetector() {
        throw new IllegalStateException("Static only class. No instances should exist for the class!");
    }

    private static String detectByExtensionInternal(String name) {
        int extensionIndex = name.lastIndexOf(EXTENSION_DELIMITER);
        if (extensionIndex >= 0) {
            return ADDITIONAL_EXTENSION_MAPPING.get(name.substring(extensionIndex));
        }
        return null;
    }

    @Nonnull
    public static String detect(@Nonnull File file) throws IOException {
        String type = URLConnection.guessContentTypeFromStream(new FileInputStream(file));
        if (type == null) {
            type = Files.probeContentType(file.toPath());
        }
        if (type == null) {
            type = URLConnection.guessContentTypeFromName(file.getName());
        }
        if (type == null) {
            type = MimeTypeDetector.detectByExtensionInternal(file.getName());
        }
        return type == null ? UNKNOWN_TYPE : type;
    }

    @Nonnull
    public static String detect(@Nonnull ByteSource source, @Nullable String resourceName) throws IOException {
        String type = URLConnection.guessContentTypeFromStream(source.openStream());
        if (resourceName != null) {
            if (type == null) {
                type = Files.probeContentType(Paths.get(resourceName, new String[0]));
            }
            if (type == null) {
                type = URLConnection.guessContentTypeFromName(resourceName);
            }
            if (type == null) {
                type = MimeTypeDetector.detectByExtensionInternal(resourceName);
            }
        }
        return type == null ? UNKNOWN_TYPE : type;
    }
}

