/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.annotation.Nonnull;

public class ObjectUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private ObjectUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static String toString(@Nonnull Object pojoObject) {
        try {
            return MAPPER.writeValueAsString(pojoObject);
        }
        catch (IOException e) {
            throw new InternalReportPortalClientException("Unable to serialize " + pojoObject.getClass().getSimpleName() + " object to String", e);
        }
    }

    @Nonnull
    public static <T> T clonePojo(@Nonnull T pojoObject, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(ObjectUtils.toString(pojoObject), clazz);
        }
        catch (IOException e) {
            throw new InternalReportPortalClientException("Unable to clone " + pojoObject.getClass().getSimpleName() + " object", e);
        }
    }
}

