/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.properties;

import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.properties.ListenerProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesLoader.class);
    public static final String PROPERTIES_PATH_PROPERTY = "rp.properties.path";
    public static final String INNER_PATH = "reportportal.properties";
    public static final Charset STANDARD_CHARSET = StandardCharsets.UTF_8;
    private final Supplier<Properties> propertiesSupplier;

    private static Properties loadProperties(String resource) throws IOException {
        Properties props = new Properties();
        Optional<URL> propertyFile = PropertiesLoader.getResource(resource);
        if (propertyFile.isPresent()) {
            try (InputStream is = propertyFile.get().openStream();){
                props.load(new InputStreamReader(is, STANDARD_CHARSET));
            }
        }
        PropertiesLoader.overrideWith(props, System.getenv());
        PropertiesLoader.overrideWith(props, System.getProperties());
        return props;
    }

    public static PropertiesLoader load(String resource) {
        return new PropertiesLoader(() -> {
            try {
                return PropertiesLoader.loadProperties(resource);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to load ReportPortal property file: " + e.getMessage(), (Throwable)e);
                return new Properties();
            }
        });
    }

    public static String getPropertyFilePath() {
        return Optional.ofNullable(PropertiesLoader.normalizeOverrides(System.getProperties()).get(PROPERTIES_PATH_PROPERTY)).filter(StringUtils::isNotBlank).orElseGet(() -> Optional.ofNullable(PropertiesLoader.normalizeOverrides(System.getenv()).get(PROPERTIES_PATH_PROPERTY)).filter(StringUtils::isNotBlank).orElse(INNER_PATH));
    }

    public static PropertiesLoader load() {
        return PropertiesLoader.load(PropertiesLoader.getPropertyFilePath());
    }

    private PropertiesLoader(Supplier<Properties> propertiesSupplier) {
        this.propertiesSupplier = new MemoizingSupplier<Properties>(propertiesSupplier);
    }

    public String getProperty(String propertyName) {
        return this.propertiesSupplier.get().getProperty(propertyName);
    }

    public String getProperty(ListenerProperty propertyName, String defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return value != null ? value : defaultValue;
    }

    public boolean getPropertyAsBoolean(ListenerProperty propertyName, boolean defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return null != value ? Boolean.parseBoolean(value) : defaultValue;
    }

    public int getPropertyAsInt(ListenerProperty propertyName, int defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return null != value ? Integer.parseInt(value) : defaultValue;
    }

    public long getPropertyAsLong(ListenerProperty propertyName, long defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return null != value ? Long.parseLong(value) : defaultValue;
    }

    public String getProperty(ListenerProperty propertyName) {
        return this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
    }

    public Properties getProperties() {
        return this.propertiesSupplier.get();
    }

    private static Map<String, String> normalizeOverrides(Map<?, ?> overrides) {
        return overrides.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString().toLowerCase().replace('_', '.'), e -> e.getValue().toString(), (original, duplicate) -> {
            LOGGER.warn("Duplicate key found in property overrides.");
            return original;
        }));
    }

    public void overrideWith(Properties overrides) {
        PropertiesLoader.overrideWith(this.propertiesSupplier.get(), overrides);
    }

    static void overrideWith(Properties source, Map<?, ?> overrides) {
        Map<String, String> overridesNormalized = PropertiesLoader.normalizeOverrides(overrides);
        for (ListenerProperty listenerProperty : ListenerProperty.values()) {
            if (overridesNormalized.get(listenerProperty.getPropertyName()) == null) continue;
            source.setProperty(listenerProperty.getPropertyName(), overridesNormalized.get(listenerProperty.getPropertyName()));
        }
    }

    static void overrideWith(Properties source, Properties overrides) {
        PropertiesLoader.overrideWith(source, overrides);
    }

    private static Optional<URL> getResource(String resourceName) {
        ClassLoader loader = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElse(PropertiesLoader.class.getClassLoader());
        return Optional.ofNullable(loader.getResource(resourceName));
    }
}

