/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.annotations.attribute.Attribute;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AttributeParser {
    public static final String ATTRIBUTES_SPLITTER = ";";
    public static final String KEY_VALUE_SPLITTER = ":";

    private AttributeParser() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static Set<ItemAttributesRQ> parseAsSet(@Nullable String rawAttributes) {
        String[] attributesSplit;
        if (null == rawAttributes) {
            return Collections.emptySet();
        }
        HashSet<ItemAttributesRQ> attributes = new HashSet<ItemAttributesRQ>();
        for (String s : attributesSplit = rawAttributes.trim().split(ATTRIBUTES_SPLITTER)) {
            ItemAttributesRQ itemAttributeResource = AttributeParser.splitKeyValue(s);
            if (itemAttributeResource == null) continue;
            attributes.add(itemAttributeResource);
        }
        return attributes;
    }

    @Nullable
    public static ItemAttributesRQ splitKeyValue(@Nullable String attribute) {
        if (null == attribute || attribute.trim().isEmpty()) {
            return null;
        }
        String[] keyValue = attribute.split(KEY_VALUE_SPLITTER);
        if (keyValue.length == 1) {
            return new ItemAttributesRQ(null, keyValue[0].trim());
        }
        if (keyValue.length == 2) {
            String key = keyValue[0].trim();
            if (key.isEmpty()) {
                key = null;
            }
            return new ItemAttributesRQ(key, keyValue[1].trim());
        }
        return null;
    }

    @Nonnull
    public static Set<ItemAttributesRQ> retrieveAttributes(@Nonnull Attributes attributesAnnotation) {
        LinkedHashSet<ItemAttributesRQ> itemAttributes = new LinkedHashSet<ItemAttributesRQ>();
        for (Attribute attribute : attributesAnnotation.attributes()) {
            if (attribute.value().trim().isEmpty()) continue;
            itemAttributes.add(AttributeParser.createItemAttribute(attribute.key(), attribute.value()));
        }
        for (Annotation annotation : attributesAnnotation.attributeValues()) {
            if (annotation.value().trim().isEmpty()) continue;
            itemAttributes.add(AttributeParser.createItemAttribute(null, annotation.value()));
        }
        for (Annotation annotation : attributesAnnotation.multiKeyAttributes()) {
            itemAttributes.addAll(AttributeParser.createItemAttributes(annotation.keys(), annotation.value()));
        }
        for (Annotation annotation : attributesAnnotation.multiValueAttributes()) {
            itemAttributes.addAll(AttributeParser.createItemAttributes(annotation.isNullKey() ? null : annotation.key(), annotation.values()));
        }
        return itemAttributes;
    }

    @Nonnull
    public static List<ItemAttributesRQ> createItemAttributes(@Nullable String[] keys, @Nullable String value) {
        if (value == null || value.trim().isEmpty()) {
            return Collections.emptyList();
        }
        if (keys == null || keys.length < 1) {
            return Collections.singletonList(AttributeParser.createItemAttribute(null, value));
        }
        return Arrays.stream(keys).map(k -> AttributeParser.createItemAttribute(k, value)).collect(Collectors.toList());
    }

    @Nonnull
    public static List<ItemAttributesRQ> createItemAttributes(@Nullable String key, @Nullable String[] values) {
        if (values != null && values.length > 0) {
            return Arrays.stream(values).filter(StringUtils::isNotBlank).map(v -> AttributeParser.createItemAttribute(key, v)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static ItemAttributesRQ createItemAttribute(@Nullable String key, @Nonnull String value) {
        return new ItemAttributesRQ(key, value);
    }
}

