/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.files;

import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.reportportal.utils.files.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;

public class Utils {
    private static final int KILOBYTE = (int)Math.pow(2.0, 10.0);
    private static final int READ_BUFFER = 10 * KILOBYTE;

    private Utils() {
    }

    @Nonnull
    public static String readInputStreamToString(@Nonnull InputStream is) throws IOException {
        byte[] bytes = Utils.readInputStreamToBytes(is);
        if (bytes.length <= 0) {
            return "";
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] readInputStreamToBytes(@Nonnull InputStream is) throws IOException {
        return Utils.readInputStreamToBytes(is, READ_BUFFER);
    }

    public static int copyStreams(@Nonnull InputStream is, @Nonnull OutputStream os, int bufferSize) throws IOException {
        int read;
        byte[] buffer = new byte[bufferSize];
        int total = 0;
        while ((read = is.read(buffer)) > 0) {
            total += read;
            os.write(buffer, 0, read);
        }
        return total;
    }

    public static int copyStreams(@Nonnull InputStream is, @Nonnull OutputStream os) throws IOException {
        return Utils.copyStreams(is, os, READ_BUFFER);
    }

    public static byte[] readInputStreamToBytes(@Nonnull InputStream is, int bufferSize) throws IOException {
        int read;
        ReadableByteChannel channel = Channels.newChannel(is);
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((read = channel.read(buffer)) > 0) {
            baos.write(buffer.array(), 0, read);
            buffer.clear();
        }
        return baos.toByteArray();
    }

    public static byte[] readFileToBytes(@Nonnull File file) throws IOException {
        return Utils.readInputStreamToBytes(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    @Nonnull
    public static InputStream getResourceAsStream(@Nonnull String path) throws FileNotFoundException {
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        if (resource == null && (resource = Utils.class.getResourceAsStream(path)) == null) {
            throw new FileNotFoundException("Unable to locate file of path: " + path);
        }
        return resource;
    }

    @Nonnull
    public static URL getResource(@Nonnull String path) throws FileNotFoundException {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(path);
        if (resource == null && (resource = Utils.class.getResource(path)) == null) {
            throw new FileNotFoundException("Unable to locate file of path: " + path);
        }
        return resource;
    }

    public static ByteSource getFileAsByteSource(@Nonnull File file) throws IOException {
        byte[] data = file.exists() && file.isFile() ? Utils.readFileToBytes(file) : Utils.readInputStreamToBytes(Utils.getResourceAsStream(file.getPath()));
        return ByteSource.wrap(data);
    }

    public static TypeAwareByteSource getFile(@Nonnull File file) throws IOException {
        String name = file.getName();
        ByteSource byteSource = Utils.getFileAsByteSource(file);
        return new TypeAwareByteSource(byteSource, MimeTypeDetector.detect(byteSource, name));
    }
}

