/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.service.Launch;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class LoggingContext {
    private static final Queue<LoggingContext> USED_CONTEXTS = new ConcurrentLinkedQueue<LoggingContext>();
    private static final ThreadLocal<Pair<Long, Deque<LoggingContext>>> CONTEXT_THREAD_LOCAL = new InheritableThreadLocal<Pair<Long, Deque<LoggingContext>>>();
    private static final Set<Long> THREAD_IDS = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Queue<Completable> completables = new ConcurrentLinkedQueue<Completable>();
    private final Maybe<String> itemUuid;

    @Nonnull
    private static Deque<LoggingContext> createContext() {
        Long threadKey = Thread.currentThread().getId();
        if (!THREAD_IDS.contains(threadKey) || CONTEXT_THREAD_LOCAL.get() == null) {
            ArrayDeque<LoggingContext> context = new ArrayDeque<LoggingContext>();
            CONTEXT_THREAD_LOCAL.set((Pair<Long, Deque<LoggingContext>>)Pair.of((Object)threadKey, context));
            THREAD_IDS.add(threadKey);
            return context;
        }
        return (Deque)CONTEXT_THREAD_LOCAL.get().getValue();
    }

    @Nullable
    private static Deque<LoggingContext> getContext() {
        Long threadKey = Thread.currentThread().getId();
        return Optional.ofNullable(CONTEXT_THREAD_LOCAL.get()).filter(ctx -> threadKey.equals(ctx.getKey())).map(Pair::getValue).orElse(null);
    }

    @Nullable
    public static LoggingContext context() {
        return Optional.ofNullable(CONTEXT_THREAD_LOCAL.get()).map(Pair::getValue).map(Deque::peek).orElse(null);
    }

    @Nonnull
    public static LoggingContext init(@Nonnull Maybe<String> itemUuid) {
        LoggingContext context = new LoggingContext(itemUuid);
        LoggingContext.createContext().push(context);
        return context;
    }

    public static void dispose() {
        int removeFactor = 100;
        Optional.ofNullable(LoggingContext.getContext()).map(Deque::poll).ifPresent(context -> {
            USED_CONTEXTS.add((LoggingContext)context);
            if (context.hashCode() % removeFactor == 0) {
                USED_CONTEXTS.removeIf(ctx -> {
                    ctx.completables.removeIf(c -> c.test().completions() > 0L);
                    return ctx.completables.isEmpty();
                });
            }
        });
    }

    public static Completable completed() {
        Completable completable = Completable.merge((Iterable)USED_CONTEXTS.stream().map(LoggingContext::complete).collect(Collectors.toList()));
        Deque<LoggingContext> context = LoggingContext.getContext();
        return Optional.ofNullable(context).map(ctx -> Completable.concat(Arrays.asList(completable, Completable.merge((Iterable)ctx.stream().map(LoggingContext::complete).collect(Collectors.toList()))))).orElse(completable);
    }

    LoggingContext(@Nonnull Maybe<String> itemUuid) {
        this.itemUuid = itemUuid;
    }

    public void emit(@Nonnull Maybe<String> logItemUuid, @Nonnull Function<String, SaveLogRQ> logSupplier) {
        Launch launch = Launch.currentLaunch();
        if (launch == null) {
            return;
        }
        Maybe future = logItemUuid.map(itemUuid -> {
            launch.log((SaveLogRQ)logSupplier.apply((String)itemUuid));
            return itemUuid;
        }).cache();
        this.completables.add(future.ignoreElement());
        future.subscribe(SubscriptionUtils.logMaybeResults("LoggingContext"));
    }

    public void emit(@Nonnull Function<String, SaveLogRQ> logSupplier) {
        this.emit(this.itemUuid, logSupplier);
    }

    public Completable complete() {
        Completable completable = Completable.merge(this.completables);
        this.completables.clear();
        return completable;
    }
}

