/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.launch.lock;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.launch.lock.AbstractLaunchIdLock;
import com.epam.reportportal.utils.Waiter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchIdLockSocket
extends AbstractLaunchIdLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaunchIdLockSocket.class);
    public static final Charset TRANSFER_CHARSET = StandardCharsets.ISO_8859_1;
    private static final int SOCKET_BACKLOG = 50;
    private static final String COMMAND_DELIMITER = " - ";
    private static final String OK_SUFFIX = " - OK";
    private static final Map<String, Date> INSTANCES = new ConcurrentHashMap<String, Date>();
    private static final ReentrantLock classLevelLock = new ReentrantLock();
    private static volatile ServerSocket mainLock;
    private static volatile String lockUuid;
    private volatile ServerHandler handler;
    private final int portNumber;
    private final long instanceWaitTimeout;

    public LaunchIdLockSocket(ListenerParameters listenerParameters) {
        super(listenerParameters);
        this.portNumber = listenerParameters.getLockPortNumber();
        this.instanceWaitTimeout = listenerParameters.getLockWaitTimeout();
    }

    String sendCommand(@Nonnull Command command, @Nonnull String instanceUuid) {
        String result = new Waiter("Wait for a socket connection").duration(this.instanceWaitTimeout, TimeUnit.MILLISECONDS).applyRandomDiscrepancy(0.1f).pollingEvery(1L, TimeUnit.SECONDS).till(() -> {
            try (Socket socket = new Socket(InetAddress.getLocalHost(), this.portNumber);){
                byte[] launchAnswerBuffer = new byte[instanceUuid.getBytes(TRANSFER_CHARSET).length];
                InputStream is = socket.getInputStream();
                is.read(launchAnswerBuffer);
                String launchUuid = new String(launchAnswerBuffer, TRANSFER_CHARSET);
                byte[] saveBuffer = (command.name() + COMMAND_DELIMITER + instanceUuid).getBytes(TRANSFER_CHARSET);
                OutputStream os = socket.getOutputStream();
                os.write(saveBuffer);
                os.flush();
                String expectedAnswer = instanceUuid + OK_SUFFIX;
                byte[] answerBuffer = new byte[expectedAnswer.getBytes(TRANSFER_CHARSET).length];
                is.read(answerBuffer);
                String answer = new String(answerBuffer, TRANSFER_CHARSET);
                if (!expectedAnswer.equals(answer)) {
                    LOGGER.warn("Invalid server instance UUID '{}' answer", (Object)command.name());
                    String string2 = null;
                    return string2;
                }
                String string = launchUuid;
                return string;
            }
            catch (IOException e) {
                LOGGER.warn("Unable to '{}' instance UUID on port '{}', connection error", new Object[]{command.name(), this.portNumber, e});
                return null;
            }
        });
        return result == null ? instanceUuid : result;
    }

    private String executeCommand(@Nonnull Command command, @Nonnull String instanceUuid) {
        if (mainLock != null) {
            switch (command) {
                case UPDATE: {
                    INSTANCES.put(instanceUuid, new Date());
                    break;
                }
                case FINISH: {
                    INSTANCES.remove(instanceUuid);
                }
            }
            return lockUuid;
        }
        return this.sendCommand(command, instanceUuid);
    }

    private String writeInstanceUuid(@Nonnull String instanceUuid) {
        return this.executeCommand(Command.UPDATE, instanceUuid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String obtainLaunchUuid(@Nonnull String uuid) {
        Objects.requireNonNull(uuid);
        if (mainLock == null) {
            classLevelLock.lock();
            try {
                if (mainLock == null) {
                    mainLock = new ServerSocket(this.portNumber, 50, InetAddress.getLocalHost());
                    lockUuid = uuid;
                    INSTANCES.put(uuid, new Date());
                }
                classLevelLock.unlock();
            }
            catch (IOException e) {
                classLevelLock.unlock();
                LOGGER.debug("Unable to obtain lock socket", (Throwable)e);
            }
            if (!uuid.equals(lockUuid)) return this.writeInstanceUuid(uuid);
            this.handler = new ServerHandler();
            this.handler.start();
            return lockUuid;
        }
        if (uuid.equals(lockUuid)) return lockUuid;
        this.writeInstanceUuid(uuid);
        return lockUuid;
    }

    @Override
    public void updateInstanceUuid(@Nonnull String instanceUuid) {
        this.writeInstanceUuid(instanceUuid);
    }

    void reset() {
        if (this.handler != null) {
            this.handler.running = false;
            this.handler = null;
        }
        lockUuid = null;
        INSTANCES.clear();
        if (mainLock != null) {
            ServerSocket socket = mainLock;
            mainLock = null;
            try {
                socket.close();
            }
            catch (IOException e) {
                LOGGER.warn("Unable to close server socket properly", (Throwable)e);
            }
        }
    }

    @Override
    public void finishInstanceUuid(@Nonnull String instanceUuid) {
        this.executeCommand(Command.FINISH, instanceUuid);
        if (mainLock != null && instanceUuid.equals(lockUuid)) {
            classLevelLock.lock();
            if (mainLock != null) {
                this.reset();
            }
            classLevelLock.unlock();
        }
    }

    @Override
    @Nonnull
    public Collection<String> getLiveInstanceUuids() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(14, -this.instanceWaitTimeout < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)(-this.instanceWaitTimeout));
        Date timeoutTime = calendar.getTime();
        return INSTANCES.entrySet().stream().filter(e -> ((Date)e.getValue()).after(timeoutTime)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private static class ServerHandler
    extends Thread {
        private final Random random = new Random();
        private final Queue<Socket> workSockets = new LinkedList<Socket>();
        private volatile boolean running = true;

        public ServerHandler() {
            this.setDaemon(true);
            this.setName("rp-launch-join");
        }

        @Override
        public void run() {
            Socket current;
            while (this.running) {
                try {
                    Socket current2;
                    Socket s = mainLock.accept();
                    this.workSockets.add(s);
                    OutputStream os = s.getOutputStream();
                    byte[] launchUuid = lockUuid.getBytes(TRANSFER_CHARSET);
                    os.write(launchUuid);
                    os.flush();
                    byte[] updateUuid = new byte[(Command.UPDATE.name() + LaunchIdLockSocket.COMMAND_DELIMITER + lockUuid).getBytes(TRANSFER_CHARSET).length];
                    InputStream is = s.getInputStream();
                    is.read(updateUuid);
                    String data = new String(updateUuid, TRANSFER_CHARSET);
                    Command command = Command.valueOf(data.substring(0, data.indexOf(LaunchIdLockSocket.COMMAND_DELIMITER)));
                    String instanceUuid = data.substring(data.indexOf(LaunchIdLockSocket.COMMAND_DELIMITER) + LaunchIdLockSocket.COMMAND_DELIMITER.length());
                    switch (command) {
                        case UPDATE: {
                            INSTANCES.put(instanceUuid, new Date());
                            break;
                        }
                        case FINISH: {
                            INSTANCES.remove(instanceUuid);
                        }
                    }
                    String answer = instanceUuid + LaunchIdLockSocket.OK_SUFFIX;
                    byte[] answerBuffer = answer.getBytes(TRANSFER_CHARSET);
                    os.write(answerBuffer);
                    os.flush();
                    if (this.random.nextInt(5) != 0) continue;
                    LinkedList<Socket> checked = new LinkedList<Socket>();
                    while ((current2 = this.workSockets.poll()) != null) {
                        if (current2.isClosed()) continue;
                        checked.add(current2);
                    }
                    this.workSockets.addAll(checked);
                }
                catch (IOException e) {
                    LOGGER.warn("Error serving server connections: ", (Throwable)e);
                }
            }
            while ((current = this.workSockets.poll()) != null) {
                if (current.isClosed()) continue;
                try {
                    current.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close socket properly", (Throwable)e);
                }
            }
        }
    }

    static enum Command {
        UPDATE,
        FINISH;

    }
}

