/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.utils.files.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static KeyStore loadKeyStore(@Nonnull String keyStore, @Nullable String password, @Nonnull String type) {
        try (InputStream is = Utils.getFile(new File(keyStore)).openStream();){
            KeyStore trustStore = KeyStore.getInstance(type);
            trustStore.load(is, Optional.ofNullable(password).map(String::toCharArray).orElse(null));
            KeyStore keyStore2 = trustStore;
            return keyStore2;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            String error = "Unable to load key store";
            LOGGER.error(error, (Throwable)e);
            throw new InternalReportPortalClientException(error, e);
        }
    }
}

