/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.service.ReportPortalClient;
import com.epam.ta.reportportal.ws.model.BatchSaveOperatingRS;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.util.List;
import okhttp3.MultipartBody;
import retrofit2.http.Body;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;

public interface ReportPortalClientV2
extends ReportPortalClient {
    @Override
    @POST(value="v2/{projectName}/launch")
    public Maybe<StartLaunchRS> startLaunch(@Body StartLaunchRQ var1);

    @Override
    @POST(value="v2/{projectName}/launch/merge")
    public Maybe<LaunchResource> mergeLaunches(@Body MergeLaunchesRQ var1);

    @Override
    @PUT(value="v2/{projectName}/launch/{launchId}/finish")
    public Maybe<OperationCompletionRS> finishLaunch(@Path(value="launchId") String var1, @Body FinishExecutionRQ var2);

    @Override
    @POST(value="v2/{projectName}/item")
    public Maybe<ItemCreatedRS> startTestItem(@Body StartTestItemRQ var1);

    @Override
    @POST(value="v2/{projectName}/item/{parent}")
    public Maybe<ItemCreatedRS> startTestItem(@Path(value="parent") String var1, @Body StartTestItemRQ var2);

    @Override
    @PUT(value="v2/{projectName}/item/{itemId}")
    public Maybe<OperationCompletionRS> finishTestItem(@Path(value="itemId") String var1, @Body FinishTestItemRQ var2);

    @Override
    @POST(value="v2/{projectName}/log")
    public Maybe<EntryCreatedAsyncRS> log(@Body SaveLogRQ var1);

    @Override
    @Multipart
    @POST(value="v2/{projectName}/log")
    public Maybe<BatchSaveOperatingRS> log(@Part List<MultipartBody.Part> var1);
}

