/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.files;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.utils.files.ByteSource;
import com.epam.reportportal.utils.http.ContentType;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.imageio.ImageIO;

public class ImageConverter {
    public static final String IMAGE_TYPE = "image";

    public static TypeAwareByteSource convertIfImage(TypeAwareByteSource content) {
        try {
            return ImageConverter.isImage(content) ? ImageConverter.convert(content) : content;
        }
        catch (IOException e) {
            throw new InternalReportPortalClientException("Unable to read screenshot file. " + e);
        }
    }

    public static TypeAwareByteSource convert(ByteSource source) throws IOException {
        try (InputStream in = source.openBufferedStream();){
            BufferedImage image = ImageIO.read(in);
            if (image == null) {
                throw new IOException("Unsupported or unreadable image content");
            }
            BufferedImage blackAndWhiteImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 10);
            Graphics2D graphics2D = (Graphics2D)blackAndWhiteImage.getGraphics();
            graphics2D.drawImage((Image)image, 0, 0, null);
            graphics2D.dispose();
            TypeAwareByteSource typeAwareByteSource = ImageConverter.convertToInputStream(blackAndWhiteImage);
            return typeAwareByteSource;
        }
    }

    public static boolean isImage(TypeAwareByteSource source) {
        return ImageConverter.isImage(source.getMediaType());
    }

    public static boolean isImage(String contentType) {
        return Optional.ofNullable(ContentType.stripMediaType(contentType)).map(type -> type.startsWith(IMAGE_TYPE)).orElse(false);
    }

    private static TypeAwareByteSource convertToInputStream(BufferedImage image) {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", byteOutputStream);
        }
        catch (IOException e) {
            throw new InternalReportPortalClientException("Unable to transform file to byte array.", e);
        }
        return new TypeAwareByteSource(ByteSource.wrap(byteOutputStream.toByteArray()), "image/png");
    }
}

