/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AccessibleMethod {
    private final Method method;
    private final Object bean;

    AccessibleMethod(@Nonnull Object bean, @Nonnull Method method) {
        this.bean = bean;
        this.method = method;
    }

    @Nullable
    public Object invoke(Object ... args) throws Throwable {
        try {
            return this.invoke(this.bean, this.method, args);
        }
        catch (IllegalAccessException accessException) {
            this.method.setAccessible(true);
            try {
                return this.invoke(this.bean, this.method, args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    @Nullable
    private Object invoke(@Nonnull Object bean, @Nonnull Method m, Object ... args) throws Throwable {
        try {
            return m.invoke(bean, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

