/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.logs;

import com.epam.ta.reportportal.ws.model.BatchSaveOperatingRS;
import io.reactivex.FlowableSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSubscriber
implements FlowableSubscriber<BatchSaveOperatingRS> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingSubscriber.class);
    private final AtomicInteger counter = new AtomicInteger(0);

    public void onSubscribe(@Nonnull Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    public void onNext(BatchSaveOperatingRS result) {
        this.counter.incrementAndGet();
    }

    public int getProcessedCount() {
        return this.counter.get();
    }

    public void onError(Throwable e) {
        LOGGER.error("[{}] ReportPortal logging error", (Object)Thread.currentThread().getId(), (Object)e);
        this.counter.incrementAndGet();
    }

    public void onComplete() {
    }
}

