/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.aspect;

import com.epam.reportportal.annotations.Step;
import com.epam.reportportal.utils.formatting.templating.TemplateConfiguration;
import com.epam.reportportal.utils.formatting.templating.TemplateProcessing;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class StepNameUtils {
    private StepNameUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static String getStepName(@Nonnull Step step, @Nonnull MethodSignature signature, @Nonnull JoinPoint joinPoint) {
        String nameTemplate = step.value();
        if (nameTemplate.trim().isEmpty()) {
            return signature.getMethod().getName();
        }
        TemplateConfiguration config = new TemplateConfiguration(step.config());
        return StepNameUtils.getStepName(nameTemplate, config, signature, joinPoint);
    }

    @Nonnull
    public static String getStepName(@Nonnull String nameTemplate, @Nonnull TemplateConfiguration config, @Nonnull MethodSignature signature, @Nonnull JoinPoint joinPoint) {
        Map<String, Object> parametersMap = StepNameUtils.createParamsMapping(signature, joinPoint);
        return TemplateProcessing.processTemplate(nameTemplate, joinPoint.getThis(), signature.getMethod(), parametersMap, config);
    }

    @Nonnull
    static Map<String, Object> createParamsMapping(@Nonnull MethodSignature signature, @Nonnull JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        String[] parameterNames = signature.getParameterNames();
        int paramsCount = Math.min(Optional.ofNullable(parameterNames).map(p -> ((String[])p).length).orElse(0), Optional.ofNullable(args).map(a -> ((Object[])a).length).orElse(0));
        HashMap<String, Object> paramsMapping = new HashMap<String, Object>();
        for (int i = 0; i < paramsCount; ++i) {
            paramsMapping.put(parameterNames[i], args[i]);
            paramsMapping.put(Integer.toString(i), args[i]);
        }
        return paramsMapping;
    }
}

