/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.listeners;

import com.epam.reportportal.service.launch.lock.LaunchIdLockMode;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.reportportal.utils.CommonConstants;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.reportportal.utils.properties.OutputTypes;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ListenerParameters
implements Cloneable {
    private static final int DEFAULT_REPORTING_TIMEOUT = 300;
    private static final int DEFAULT_IO_POOL_SIZE = Math.max(Runtime.getRuntime().availableProcessors() * 2 - 1, 1);
    private static final boolean DEFAULT_ENABLE = true;
    private static final boolean DEFAULT_SKIP_ISSUE = true;
    private static final boolean DEFAULT_CONVERT_IMAGE = false;
    private static final boolean DEFAULT_RETURN = false;
    private static final boolean DEFAULT_ASYNC_REPORTING = true;
    private static final boolean DEFAULT_CALLBACK_REPORTING_ENABLED = false;
    private static final boolean DEFAULT_HTTP_LOGGING = false;
    private static final int DEFAULT_RX_BUFFER_SIZE = 128;
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final boolean DEFAULT_CLIENT_JOIN = true;
    private static final String DEFAULT_CLIENT_JOIN_MODE = "FILE";
    private static final String DEFAULT_LOCK_FILE_NAME = "reportportal.lock";
    private static final String DEFAULT_SYNC_FILE_NAME = "reportportal.sync";
    private static final int DEFAULT_CLIENT_JOIN_LOCK_PORT = 25464;
    public static final long DEFAULT_FILE_WAIT_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    private static final long DEFAULT_CLIENT_JOIN_TIMEOUT = TimeUnit.MINUTES.toMillis(30L);
    private static final long DEFAULT_CLIENT_JOIN_LAUNCH_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    private static final String DEFAULT_CLIENT_JOIN_TIMEOUT_UNIT = "MILLISECONDS";
    private static final String DEFAULT_CLIENT_JOIN_LOCK_TIMEOUT_UNIT = "MILLISECONDS";
    private static final String DEFAULT_CLIENT_JOIN_LAUNCH_TIMEOUT_UNIT = "MILLISECONDS";
    private static final boolean DEFAULT_TRUNCATE = true;
    private static final int DEFAULT_TRUNCATE_ITEM_NAMES_LIMIT = 1024;
    private static final int DEFAULT_TRUNCATE_ATTRIBUTE_LIMIT = 128;
    public static final boolean DEFAULT_EXCEPTION_TRUNCATE = true;
    public static final int DEFAULT_LOG_BATCH_SIZE = 10;
    public static final long DEFAULT_BATCH_PAYLOAD_LIMIT = 62L * (long)CommonConstants.MEGABYTES;
    public static final boolean DEFAULT_LAUNCH_CREATION_SKIP = true;
    public static final boolean DEFAULT_LAUNCH_UUID_PRINT = false;
    public static final String DEFAULT_LAUNCH_UUID_OUTPUT = "stdout";
    public static final boolean DEFAULT_BTS_ISSUE_FAIL = true;
    private String description;
    private String apiKey;
    private String baseUrl;
    private String proxyUrl;
    private String proxyUser;
    private String proxyPassword;
    private boolean httpLogging;
    private Duration httpCallTimeout;
    private Duration httpConnectTimeout;
    private Duration httpReadTimeout;
    private Duration httpWriteTimeout;
    private String projectName;
    private String launchName;
    private Mode launchRunningMode;
    private Set<ItemAttributesRQ> attributes;
    private Boolean enable;
    private Boolean isSkippedAnIssue;
    private Integer batchLogsSize;
    private Long batchPayloadLimit;
    private boolean convertImage;
    private Integer reportingTimeout;
    private String keystore;
    private String keystorePassword;
    private String keystoreType;
    private String truststore;
    private String truststorePassword;
    private String truststoreType;
    private boolean rerun;
    private String rerunOf;
    private boolean asyncReporting;
    private boolean callbackReportingEnabled;
    private Integer ioPoolSize;
    private boolean clientJoin;
    private LaunchIdLockMode clientJoinMode;
    private String lockFileName;
    private String syncFileName;
    private int lockPortNumber;
    private long lockWaitTimeout;
    private long clientJoinTimeout;
    private long clientJoinLaunchTimeout;
    private int rxBufferSize;
    private boolean truncateFields;
    private int truncateItemNamesLimit;
    private String truncateReplacement;
    private int attributeLengthLimit;
    private boolean exceptionTruncate;
    private String launchUuid;
    private boolean isLaunchUuidCreationSkip;
    private boolean printLaunchUuid;
    private PrintStream printLaunchUuidOutput;
    private String btsProjectId;
    private String btsUrl;
    private String btsIssueUrl;
    private boolean btsIssueFail;

    @Nonnull
    private static ChronoUnit toChronoUnit(@Nonnull TimeUnit t) {
        switch (t) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError();
    }

    @Nullable
    private static Duration getDurationProperty(@Nonnull PropertiesLoader properties, @Nonnull ListenerProperty value, @Nonnull ListenerProperty unit) {
        return Optional.ofNullable(properties.getProperty(value)).map(Long::parseLong).map(t -> Duration.of(t, Optional.ofNullable(properties.getProperty(unit)).map(u -> ListenerParameters.toChronoUnit(TimeUnit.valueOf(u))).orElse(ChronoUnit.MILLIS))).orElse(null);
    }

    public ListenerParameters() {
        this.isSkippedAnIssue = true;
        this.batchLogsSize = 10;
        this.batchPayloadLimit = DEFAULT_BATCH_PAYLOAD_LIMIT;
        this.convertImage = false;
        this.reportingTimeout = 300;
        this.httpLogging = false;
        this.keystoreType = DEFAULT_KEYSTORE_TYPE;
        this.truststoreType = DEFAULT_KEYSTORE_TYPE;
        this.attributes = Collections.emptySet();
        this.rerun = false;
        this.asyncReporting = true;
        this.callbackReportingEnabled = false;
        this.ioPoolSize = DEFAULT_IO_POOL_SIZE;
        this.clientJoin = true;
        this.clientJoinMode = LaunchIdLockMode.valueOf(DEFAULT_CLIENT_JOIN_MODE);
        this.lockPortNumber = 25464;
        this.lockFileName = DEFAULT_LOCK_FILE_NAME;
        this.syncFileName = DEFAULT_SYNC_FILE_NAME;
        this.lockWaitTimeout = DEFAULT_FILE_WAIT_TIMEOUT;
        this.clientJoinTimeout = DEFAULT_CLIENT_JOIN_TIMEOUT;
        this.clientJoinLaunchTimeout = DEFAULT_CLIENT_JOIN_LAUNCH_TIMEOUT;
        this.rxBufferSize = 128;
        this.truncateFields = true;
        this.truncateItemNamesLimit = 1024;
        this.truncateReplacement = "...";
        this.attributeLengthLimit = 128;
        this.printLaunchUuid = false;
        this.printLaunchUuidOutput = OutputTypes.valueOf(DEFAULT_LAUNCH_UUID_OUTPUT.toUpperCase(Locale.ROOT)).getOutput();
        this.isLaunchUuidCreationSkip = true;
        this.btsIssueFail = true;
        this.exceptionTruncate = true;
    }

    public ListenerParameters(PropertiesLoader properties) {
        this.description = properties.getProperty(ListenerProperty.DESCRIPTION);
        this.apiKey = Optional.ofNullable(properties.getProperty(ListenerProperty.API_KEY, properties.getProperty(ListenerProperty.UUID))).map(String::trim).orElse(null);
        this.baseUrl = properties.getProperty(ListenerProperty.BASE_URL) != null ? properties.getProperty(ListenerProperty.BASE_URL).trim() : null;
        this.proxyUrl = properties.getProperty(ListenerProperty.HTTP_PROXY_URL);
        this.proxyUser = properties.getProperty(ListenerProperty.HTTP_PROXY_USER);
        this.proxyPassword = properties.getProperty(ListenerProperty.HTTP_PROXY_PASSWORD);
        this.httpLogging = properties.getPropertyAsBoolean(ListenerProperty.HTTP_LOGGING, false);
        this.httpCallTimeout = ListenerParameters.getDurationProperty(properties, ListenerProperty.HTTP_CALL_TIMEOUT_VALUE, ListenerProperty.HTTP_CALL_TIMEOUT_UNIT);
        this.httpConnectTimeout = ListenerParameters.getDurationProperty(properties, ListenerProperty.HTTP_CONNECT_TIMEOUT_VALUE, ListenerProperty.HTTP_CONNECT_TIMEOUT_UNIT);
        this.httpReadTimeout = ListenerParameters.getDurationProperty(properties, ListenerProperty.HTTP_READ_TIMEOUT_VALUE, ListenerProperty.HTTP_READ_TIMEOUT_UNIT);
        this.httpWriteTimeout = ListenerParameters.getDurationProperty(properties, ListenerProperty.HTTP_WRITE_TIMEOUT_VALUE, ListenerProperty.HTTP_WRITE_TIMEOUT_UNIT);
        this.projectName = properties.getProperty(ListenerProperty.PROJECT_NAME) != null ? properties.getProperty(ListenerProperty.PROJECT_NAME).trim() : null;
        this.launchName = properties.getProperty(ListenerProperty.LAUNCH_NAME);
        this.attributes = Collections.unmodifiableSet(AttributeParser.parseAsSet(properties.getProperty(ListenerProperty.LAUNCH_ATTRIBUTES)));
        this.launchRunningMode = this.parseLaunchMode(properties.getProperty(ListenerProperty.MODE));
        this.enable = properties.getPropertyAsBoolean(ListenerProperty.ENABLE, true);
        this.isSkippedAnIssue = properties.getPropertyAsBoolean(ListenerProperty.SKIPPED_AS_ISSUE, true);
        this.batchLogsSize = properties.getPropertyAsInt(ListenerProperty.BATCH_SIZE_LOGS, 10);
        this.batchPayloadLimit = properties.getPropertyAsLong(ListenerProperty.BATCH_PAYLOAD_LIMIT, DEFAULT_BATCH_PAYLOAD_LIMIT);
        this.convertImage = properties.getPropertyAsBoolean(ListenerProperty.IS_CONVERT_IMAGE, false);
        this.reportingTimeout = properties.getPropertyAsInt(ListenerProperty.REPORTING_TIMEOUT, 300);
        this.keystore = properties.getProperty(ListenerProperty.KEYSTORE_RESOURCE);
        this.keystorePassword = properties.getProperty(ListenerProperty.KEYSTORE_PASSWORD);
        this.keystoreType = properties.getProperty(ListenerProperty.KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
        this.truststore = properties.getProperty(ListenerProperty.TRUSTSTORE_RESOURCE);
        this.truststorePassword = properties.getProperty(ListenerProperty.TRUSTSTORE_PASSWORD);
        this.truststoreType = properties.getProperty(ListenerProperty.TRUSTSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
        this.rerun = properties.getPropertyAsBoolean(ListenerProperty.RERUN, false);
        this.rerunOf = properties.getProperty(ListenerProperty.RERUN_OF);
        this.asyncReporting = properties.getPropertyAsBoolean(ListenerProperty.ASYNC_REPORTING, true);
        this.callbackReportingEnabled = properties.getPropertyAsBoolean(ListenerProperty.CALLBACK_REPORTING_ENABLED, false);
        this.ioPoolSize = properties.getPropertyAsInt(ListenerProperty.IO_POOL_SIZE, DEFAULT_IO_POOL_SIZE);
        this.clientJoin = properties.getPropertyAsBoolean(ListenerProperty.CLIENT_JOIN_MODE, true);
        this.clientJoinMode = LaunchIdLockMode.valueOf(properties.getProperty(ListenerProperty.CLIENT_JOIN_MODE_VALUE, DEFAULT_CLIENT_JOIN_MODE));
        this.lockPortNumber = properties.getPropertyAsInt(ListenerProperty.CLIENT_JOIN_LOCK_PORT, 25464);
        this.lockFileName = properties.getProperty(ListenerProperty.FILE_LOCK_NAME, DEFAULT_LOCK_FILE_NAME);
        this.syncFileName = properties.getProperty(ListenerProperty.FILE_SYNC_NAME, DEFAULT_SYNC_FILE_NAME);
        this.clientJoinTimeout = Optional.ofNullable(properties.getProperty(ListenerProperty.CLIENT_JOIN_TIMEOUT_VALUE)).map(t -> TimeUnit.valueOf(properties.getProperty(ListenerProperty.CLIENT_JOIN_TIMEOUT_UNIT, "MILLISECONDS")).toMillis(Long.parseLong(t))).orElse(DEFAULT_CLIENT_JOIN_TIMEOUT);
        this.lockWaitTimeout = Optional.ofNullable(properties.getProperty(ListenerProperty.CLIENT_JOIN_LOCK_TIMEOUT_VALUE)).map(t -> TimeUnit.valueOf(properties.getProperty(ListenerProperty.CLIENT_JOIN_LOCK_TIMEOUT_UNIT, "MILLISECONDS")).toMillis(Long.parseLong(t))).orElse(DEFAULT_FILE_WAIT_TIMEOUT);
        this.clientJoinLaunchTimeout = Optional.ofNullable(properties.getProperty(ListenerProperty.CLIENT_JOIN_LAUNCH_TIMEOUT_VALUE)).map(t -> TimeUnit.valueOf(properties.getProperty(ListenerProperty.CLIENT_JOIN_LAUNCH_TIMEOUT_UNIT, "MILLISECONDS")).toMillis(Long.parseLong(t))).orElse(DEFAULT_CLIENT_JOIN_LAUNCH_TIMEOUT);
        this.rxBufferSize = properties.getPropertyAsInt(ListenerProperty.RX_BUFFER_SIZE, 128);
        this.truncateFields = properties.getPropertyAsBoolean(ListenerProperty.TRUNCATE_FIELDS, true);
        this.truncateItemNamesLimit = properties.getPropertyAsInt(ListenerProperty.TRUNCATE_ITEM_NAME_LIMIT, 1024);
        this.truncateReplacement = properties.getProperty(ListenerProperty.TRUNCATE_REPLACEMENT, "...");
        this.attributeLengthLimit = properties.getPropertyAsInt(ListenerProperty.TRUNCATE_ATTRIBUTE_LIMIT, 128);
        this.exceptionTruncate = properties.getPropertyAsBoolean(ListenerProperty.EXCEPTION_TRUNCATE, true);
        this.launchUuid = properties.getProperty(ListenerProperty.LAUNCH_UUID);
        this.isLaunchUuidCreationSkip = properties.getPropertyAsBoolean(ListenerProperty.LAUNCH_UUID_CREATION_SKIP, true);
        this.printLaunchUuid = properties.getPropertyAsBoolean(ListenerProperty.LAUNCH_UUID_PRINT, false);
        this.printLaunchUuidOutput = OutputTypes.valueOf(properties.getProperty(ListenerProperty.LAUNCH_UUID_PRINT_OUTPUT, DEFAULT_LAUNCH_UUID_OUTPUT).toUpperCase(Locale.ROOT)).getOutput();
        this.btsProjectId = properties.getProperty(ListenerProperty.BTS_PROJECT);
        this.btsUrl = properties.getProperty(ListenerProperty.BTS_URL);
        this.btsIssueUrl = properties.getProperty(ListenerProperty.BTS_ISSUE_URL);
        this.btsIssueFail = properties.getPropertyAsBoolean(ListenerProperty.BTS_ISSUE_FAIL, true);
    }

    Mode parseLaunchMode(String mode) {
        return Mode.isExists(mode) ? Mode.valueOf(mode.toUpperCase()) : Mode.DEFAULT;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getLaunchName() {
        return this.launchName;
    }

    public void setLaunchName(String launchName) {
        this.launchName = launchName;
    }

    @Nullable
    public String getLaunchUuid() {
        return this.launchUuid;
    }

    public void setLaunchUuid(@Nullable String launchUuid) {
        this.launchUuid = launchUuid;
    }

    public boolean isLaunchUuidCreationSkip() {
        return this.isLaunchUuidCreationSkip;
    }

    public void setLaunchUuidCreationSkip(boolean launchUuidCreationSkip) {
        this.isLaunchUuidCreationSkip = launchUuidCreationSkip;
    }

    public boolean isPrintLaunchUuid() {
        return this.printLaunchUuid;
    }

    public void setPrintLaunchUuid(boolean printLaunchUuid) {
        this.printLaunchUuid = printLaunchUuid;
    }

    @Nonnull
    public PrintStream getPrintLaunchUuidOutput() {
        return this.printLaunchUuidOutput;
    }

    public void setPrintLaunchUuidOutput(@Nonnull PrintStream printLaunchUuidOutput) {
        this.printLaunchUuidOutput = printLaunchUuidOutput;
    }

    public Mode getLaunchRunningMode() {
        return this.launchRunningMode;
    }

    public void setLaunchRunningMode(Mode launchRunningMode) {
        this.launchRunningMode = launchRunningMode;
    }

    public Set<ItemAttributesRQ> getAttributes() {
        return Collections.unmodifiableSet(this.attributes);
    }

    public void setAttributes(Set<ItemAttributesRQ> attributes) {
        this.attributes = new HashSet<ItemAttributesRQ>(attributes);
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getSkippedAnIssue() {
        return this.isSkippedAnIssue;
    }

    public void setSkippedAnIssue(Boolean skippedAnIssue) {
        this.isSkippedAnIssue = skippedAnIssue;
    }

    public Integer getBatchLogsSize() {
        return this.batchLogsSize;
    }

    public void setBatchLogsSize(Integer batchLogsSize) {
        this.batchLogsSize = batchLogsSize;
    }

    public Long getBatchPayloadLimit() {
        return this.batchPayloadLimit;
    }

    public void setBatchPayloadLimit(Long batchPayloadLimit) {
        this.batchPayloadLimit = batchPayloadLimit;
    }

    public boolean isConvertImage() {
        return this.convertImage;
    }

    public void setConvertImage(boolean convertImage) {
        this.convertImage = convertImage;
    }

    public Integer getReportingTimeout() {
        return this.reportingTimeout;
    }

    public void setReportingTimeout(Integer reportingTimeout) {
        this.reportingTimeout = reportingTimeout;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setKeystoreType(@Nonnull String keystoreType) {
        this.keystoreType = keystoreType;
    }

    @Nonnull
    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getTruststore() {
        return this.truststore;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public void setTruststoreType(@Nonnull String truststoreType) {
        this.truststoreType = truststoreType;
    }

    @Nonnull
    public String getTruststoreType() {
        return this.truststoreType;
    }

    public boolean isRerun() {
        return this.rerun;
    }

    public boolean isAsyncReporting() {
        return this.asyncReporting;
    }

    public void setAsyncReporting(boolean asyncReporting) {
        this.asyncReporting = asyncReporting;
    }

    public boolean isCallbackReportingEnabled() {
        return this.callbackReportingEnabled;
    }

    public void setCallbackReportingEnabled(boolean callbackReportingEnabled) {
        this.callbackReportingEnabled = callbackReportingEnabled;
    }

    public void setRerun(boolean rerun) {
        this.rerun = rerun;
    }

    public String getRerunOf() {
        return this.rerunOf;
    }

    public void setRerunOf(String rerunOf) {
        this.rerunOf = rerunOf;
    }

    public Integer getIoPoolSize() {
        return this.ioPoolSize;
    }

    public void setIoPoolSize(Integer ioPoolSize) {
        this.ioPoolSize = ioPoolSize;
    }

    public boolean getClientJoin() {
        return this.clientJoin;
    }

    public void setClientJoin(boolean mode) {
        this.clientJoin = mode;
    }

    public LaunchIdLockMode getClientJoinMode() {
        return this.clientJoinMode;
    }

    public void setClientJoinMode(LaunchIdLockMode clientJoinMode) {
        this.clientJoinMode = clientJoinMode;
    }

    public int getLockPortNumber() {
        return this.lockPortNumber;
    }

    public void setLockPortNumber(int lockPortNumber) {
        this.lockPortNumber = lockPortNumber;
    }

    public String getLockFileName() {
        return this.lockFileName;
    }

    public void setLockFileName(String fileName) {
        this.lockFileName = fileName;
    }

    public String getSyncFileName() {
        return this.syncFileName;
    }

    public void setSyncFileName(String fileName) {
        this.syncFileName = fileName;
    }

    public long getClientJoinTimeout() {
        return this.clientJoinTimeout;
    }

    public void setClientJoinTimeout(long clientJoinTimeout) {
        this.clientJoinTimeout = clientJoinTimeout;
    }

    public long getLockWaitTimeout() {
        return this.lockWaitTimeout;
    }

    public void setLockWaitTimeout(long timeout) {
        this.lockWaitTimeout = timeout;
    }

    public long getClientJoinLaunchTimeout() {
        return this.clientJoinLaunchTimeout;
    }

    public void setClientJoinLaunchTimeout(long clientJoinLaunchTimeout) {
        this.clientJoinLaunchTimeout = clientJoinLaunchTimeout;
    }

    public boolean isHttpLogging() {
        return this.httpLogging;
    }

    public void setHttpLogging(boolean httpLogging) {
        this.httpLogging = httpLogging;
    }

    public int getRxBufferSize() {
        return Optional.ofNullable(System.getProperty("rx2.buffer-size")).map(Integer::valueOf).map(s -> Math.max(1, s)).orElse(this.rxBufferSize);
    }

    public void setRxBufferSize(int size) {
        this.rxBufferSize = size;
    }

    public boolean isTruncateFields() {
        return this.truncateFields;
    }

    public void setTruncateFields(boolean truncateFields) {
        this.truncateFields = truncateFields;
    }

    public int getTruncateItemNamesLimit() {
        return this.truncateItemNamesLimit;
    }

    public void setTruncateItemNamesLimit(int limit) {
        this.truncateItemNamesLimit = limit;
    }

    public String getTruncateReplacement() {
        return this.truncateReplacement;
    }

    public void setTruncateReplacement(String replacement) {
        this.truncateReplacement = replacement;
    }

    public int getAttributeLengthLimit() {
        return this.attributeLengthLimit;
    }

    public void setAttributeLengthLimit(int attributeLengthLimit) {
        this.attributeLengthLimit = attributeLengthLimit;
    }

    public boolean isExceptionTruncate() {
        return this.exceptionTruncate;
    }

    public void setExceptionTruncate(boolean exceptionTruncate) {
        this.exceptionTruncate = exceptionTruncate;
    }

    public void setHttpCallTimeout(@Nullable Duration httpCallTimeout) {
        this.httpCallTimeout = httpCallTimeout;
    }

    @Nullable
    public Duration getHttpCallTimeout() {
        return this.httpCallTimeout;
    }

    public void setHttpConnectTimeout(@Nullable Duration httpConnectTimeout) {
        this.httpConnectTimeout = httpConnectTimeout;
    }

    @Nullable
    public Duration getHttpConnectTimeout() {
        return this.httpConnectTimeout;
    }

    public void setHttpReadTimeout(@Nullable Duration httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
    }

    @Nullable
    public Duration getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public void setHttpWriteTimeout(@Nullable Duration httpWriteTimeout) {
        this.httpWriteTimeout = httpWriteTimeout;
    }

    @Nullable
    public Duration getHttpWriteTimeout() {
        return this.httpWriteTimeout;
    }

    @Nullable
    public String getBtsProjectId() {
        return this.btsProjectId;
    }

    public void setBtsProjectId(@Nullable String btsProjectId) {
        this.btsProjectId = btsProjectId;
    }

    @Nullable
    public String getBtsUrl() {
        return this.btsUrl;
    }

    public void setBtsUrl(@Nullable String btsUrl) {
        this.btsUrl = btsUrl;
    }

    @Nullable
    public String getBtsIssueUrl() {
        return this.btsIssueUrl;
    }

    public void setBtsIssueUrl(@Nullable String btsIssueUrl) {
        this.btsIssueUrl = btsIssueUrl;
    }

    public boolean isBtsIssueFail() {
        return this.btsIssueFail;
    }

    public void setBtsIssueFail(boolean btsIssueFail) {
        this.btsIssueFail = btsIssueFail;
    }

    @Nonnull
    public ListenerParameters clone() {
        ListenerParameters clonedParent;
        try {
            clonedParent = (ListenerParameters)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            clonedParent = new ListenerParameters();
        }
        ListenerParameters clone = clonedParent;
        Arrays.stream(this.getClass().getDeclaredFields()).forEach(f -> {
            if (Modifier.isFinal(f.getModifiers())) {
                return;
            }
            try {
                f.set(clone, f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        });
        return clone;
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder("ListenerParameters{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(", apiKey='").append(this.apiKey).append('\'');
        sb.append(", baseUrl='").append(this.baseUrl).append('\'');
        sb.append(", proxyUrl='").append(this.proxyUrl).append('\'');
        sb.append(", httpLogging='").append(this.httpLogging).append('\'');
        sb.append(", httpCallTimeout='").append(this.httpCallTimeout).append('\'');
        sb.append(", httpConnectTimeout='").append(this.httpConnectTimeout).append('\'');
        sb.append(", httpReadTimeout='").append(this.httpReadTimeout).append('\'');
        sb.append(", httpWriteTimeout='").append(this.httpWriteTimeout).append('\'');
        sb.append(", projectName='").append(this.projectName).append('\'');
        sb.append(", launchName='").append(this.launchName).append('\'');
        sb.append(", launchUuid='").append(this.launchUuid).append('\'');
        sb.append(", launchUuidCreationSkip='").append(this.isLaunchUuidCreationSkip).append('\'');
        sb.append(", printLaunchUuid='").append(this.printLaunchUuid).append('\'');
        sb.append(", printLaunchUuidOutput='").append(this.printLaunchUuidOutput).append('\'');
        sb.append(", launchRunningMode=").append((Object)this.launchRunningMode);
        sb.append(", attributes=").append(this.attributes);
        sb.append(", enable=").append(this.enable);
        sb.append(", isSkippedAnIssue=").append(this.isSkippedAnIssue);
        sb.append(", batchLogsSize=").append(this.batchLogsSize);
        sb.append(", convertImage=").append(this.convertImage);
        sb.append(", reportingTimeout=").append(this.reportingTimeout);
        sb.append(", keystore='").append(this.keystore).append('\'');
        sb.append(", keystorePassword='").append(this.keystorePassword).append('\'');
        sb.append(", rerun=").append(this.rerun);
        sb.append(", rerunOf='").append(this.rerunOf).append('\'');
        sb.append(", asyncReporting=").append(this.asyncReporting);
        sb.append(", ioPoolSize=").append(this.ioPoolSize);
        sb.append(", callbackReportingEnabled=").append(this.callbackReportingEnabled);
        sb.append(", clientJoin=").append(this.clientJoin);
        sb.append(", clientJoinMode=").append((String)Optional.ofNullable(this.clientJoinMode).map(Enum::name).orElse(null));
        sb.append(", clientJoinTimeout=").append(this.clientJoinTimeout);
        sb.append(", clientJoinLaunchTimeout=").append(this.clientJoinLaunchTimeout);
        sb.append(", lockFileName=").append(this.lockFileName);
        sb.append(", syncFileName=").append(this.syncFileName);
        sb.append(", lockWaitTimeout=").append(this.lockWaitTimeout);
        sb.append(", lockPortNumber=").append(this.lockPortNumber);
        sb.append(", rxBufferSize=").append(this.rxBufferSize);
        sb.append(", truncateFields=").append(this.truncateFields);
        sb.append(", exceptionTruncate=").append(this.exceptionTruncate);
        sb.append(", btsProjectId=").append(this.btsProjectId);
        sb.append(", btsUrl=").append(this.btsUrl);
        sb.append(", btsIssueUrl=").append(this.btsIssueUrl);
        sb.append(", btsIssueFail=").append(this.btsIssueFail);
        sb.append('}');
        return sb.toString();
    }
}

