/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.step;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;

public class StepRequestUtils {
    private StepRequestUtils() {
    }

    @Nonnull
    public static StartTestItemRQ buildStartStepRequest(@Nonnull String name, @Nullable String description, @Nonnull Comparable<? extends Comparable<?>> dateTime) {
        StartTestItemRQ request = new StartTestItemRQ();
        Optional.ofNullable(description).filter(d -> !d.isEmpty()).ifPresent(request::setDescription);
        request.setName(name);
        request.setStartTime(dateTime);
        request.setType("STEP");
        request.setHasStats(false);
        return request;
    }

    @Nonnull
    public static FinishTestItemRQ buildFinishTestItemRequest(@Nonnull ItemStatus status, @Nonnull Comparable<? extends Comparable<?>> endTime) {
        FinishTestItemRQ finishTestItemRQ = new FinishTestItemRQ();
        finishTestItemRQ.setStatus(status.name());
        finishTestItemRQ.setEndTime(endTime);
        return finishTestItemRQ;
    }
}

