/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.utils.BasicUtils;
import com.epam.reportportal.utils.CommonConstants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import jakarta.annotation.Nonnull;
import java.io.IOException;

public class ObjectUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new SimpleModule().addDeserializer(String.class, (JsonDeserializer)new LimitedStringDeserializer(CommonConstants.TEN_MEGABYTES)));

    private ObjectUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static String toString(@Nonnull Object pojoObject) {
        try {
            return MAPPER.writeValueAsString(pojoObject);
        }
        catch (IOException e) {
            throw new InternalReportPortalClientException("Unable to serialize " + pojoObject.getClass().getSimpleName() + " object to String", e);
        }
    }

    @Nonnull
    public static <T> T clonePojo(@Nonnull T pojoObject, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(ObjectUtils.toString(pojoObject), clazz);
        }
        catch (IOException e) {
            throw new InternalReportPortalClientException("Unable to clone " + pojoObject.getClass().getSimpleName() + " object", e);
        }
    }

    private static class LimitedStringDeserializer
    extends StdDeserializer<String> {
        private static final long serialVersionUID = 1L;
        private final int maxLength;

        public LimitedStringDeserializer(int maxLength) {
            super(String.class);
            this.maxLength = Math.max(0, maxLength);
        }

        public String deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
            String value = p.getValueAsString();
            if (value == null) {
                return null;
            }
            return BasicUtils.truncateString(value, this.maxLength, null);
        }
    }
}

