/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.http;

import com.epam.reportportal.listeners.ListenerParameters;
import jakarta.annotation.Nonnull;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientUtils.class);

    private ClientUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static OkHttpClient.Builder setupProxy(@Nonnull OkHttpClient.Builder builder, @Nonnull ListenerParameters parameters) {
        String proxyStr = parameters.getProxyUrl();
        if (StringUtils.isBlank((CharSequence)proxyStr)) {
            return builder;
        }
        try {
            URL proxyUrl = new URL(proxyStr);
            int port = proxyUrl.getPort();
            builder.proxy(new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(proxyUrl.getHost(), port >= 0 ? port : proxyUrl.getDefaultPort())));
            String proxyUser = parameters.getProxyUser();
            if (StringUtils.isNotBlank((CharSequence)proxyUser)) {
                builder.proxyAuthenticator((route, response) -> {
                    String credential = Credentials.basic((String)proxyUser, (String)parameters.getProxyPassword(), (Charset)StandardCharsets.UTF_8);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                });
            }
        }
        catch (MalformedURLException e) {
            LOGGER.warn("Unable to parse proxy URL", (Throwable)e);
            return builder;
        }
        return builder;
    }
}

