/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class TimeSerializer
extends JsonSerializer<Object> {
    public static final DateTimeFormatter ISO_MICRO_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ").withZone(ZoneOffset.UTC);

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            gen.writeNumber(date.getTime());
        } else if (value instanceof Instant) {
            Instant instant = (Instant)value;
            gen.writeString(ISO_MICRO_FORMATTER.format(instant));
        } else if (value instanceof Long) {
            gen.writeNumber(((Long)value).longValue());
        } else {
            gen.writeString(value.toString());
        }
    }
}

