/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.annotations;

import com.epam.ta.reportportal.ws.annotations.In;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class InCollectionValidator
implements ConstraintValidator<In, Collection<String>> {
    private String[] allowedValues;

    public void initialize(In constraintAnnotation) {
        this.allowedValues = new String[constraintAnnotation.allowedValues().length];
        for (int i = 0; i < constraintAnnotation.allowedValues().length; ++i) {
            this.allowedValues[i] = constraintAnnotation.allowedValues()[i].toUpperCase();
        }
    }

    public boolean isValid(Collection<String> value, ConstraintValidatorContext context) {
        ArrayList<String> upperCaseList = new ArrayList<String>();
        for (String next : value) {
            upperCaseList.add(next.toUpperCase());
        }
        return Arrays.asList(this.allowedValues).containsAll(upperCaseList);
    }
}

