/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.protocol;

import com.facebook.drift.TException;
import com.facebook.drift.protocol.TField;
import com.facebook.drift.protocol.TList;
import com.facebook.drift.protocol.TMap;
import com.facebook.drift.protocol.TMessage;
import com.facebook.drift.protocol.TProtocol;
import com.facebook.drift.protocol.TProtocolException;
import com.facebook.drift.protocol.TProtocolUtil;
import com.facebook.drift.protocol.TSet;
import com.facebook.drift.protocol.TStruct;
import com.facebook.drift.protocol.TTransport;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class TBinaryProtocol
implements TProtocol {
    private static final TStruct ANONYMOUS_STRUCT = new TStruct("");
    protected static final int VERSION_MASK = -65536;
    protected static final int VERSION_1 = -2147418112;
    private final TTransport transport;
    private final byte[] bout = new byte[1];
    private final byte[] i16out = new byte[2];
    private final byte[] i32out = new byte[4];
    private final byte[] i64out = new byte[8];
    private final byte[] bin = new byte[1];
    private final byte[] i16rd = new byte[2];
    private final byte[] i32rd = new byte[4];
    private final byte[] i64rd = new byte[8];

    public TBinaryProtocol(TTransport transport) {
        this.transport = Objects.requireNonNull(transport, "transport is null");
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        this.writeI32(0x80010000 | message.getType() & 0xFF);
        this.writeString(message.getName());
        this.writeI32(message.getSequenceId());
    }

    @Override
    public void writeMessageEnd() {
    }

    @Override
    public void writeStructBegin(TStruct struct) {
    }

    @Override
    public void writeStructEnd() {
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        this.writeByte(field.getType());
        this.writeI16(field.getId());
    }

    @Override
    public void writeFieldEnd() {
    }

    @Override
    public void writeFieldStop() throws TException {
        this.writeByte((byte)0);
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        this.writeByte(map.getKeyType());
        this.writeByte(map.getValueType());
        this.writeI32(map.getSize());
    }

    @Override
    public void writeMapEnd() {
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        this.writeByte(list.getType());
        this.writeI32(list.getSize());
    }

    @Override
    public void writeListEnd() {
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        this.writeByte(set.getType());
        this.writeI32(set.getSize());
    }

    @Override
    public void writeSetEnd() {
    }

    @Override
    public void writeBool(boolean value) throws TException {
        this.writeByte((byte)(value ? 1 : 0));
    }

    @Override
    public void writeByte(byte value) throws TException {
        this.bout[0] = value;
        this.transport.write(this.bout, 0, 1);
    }

    @Override
    public void writeI16(short value) throws TException {
        this.i16out[0] = (byte)(0xFF & value >> 8);
        this.i16out[1] = (byte)(0xFF & value);
        this.transport.write(this.i16out, 0, 2);
    }

    @Override
    public void writeI32(int value) throws TException {
        this.i32out[0] = (byte)(0xFF & value >> 24);
        this.i32out[1] = (byte)(0xFF & value >> 16);
        this.i32out[2] = (byte)(0xFF & value >> 8);
        this.i32out[3] = (byte)(0xFF & value);
        this.transport.write(this.i32out, 0, 4);
    }

    @Override
    public void writeI64(long value) throws TException {
        this.i64out[0] = (byte)(0xFFL & value >> 56);
        this.i64out[1] = (byte)(0xFFL & value >> 48);
        this.i64out[2] = (byte)(0xFFL & value >> 40);
        this.i64out[3] = (byte)(0xFFL & value >> 32);
        this.i64out[4] = (byte)(0xFFL & value >> 24);
        this.i64out[5] = (byte)(0xFFL & value >> 16);
        this.i64out[6] = (byte)(0xFFL & value >> 8);
        this.i64out[7] = (byte)(0xFFL & value);
        this.transport.write(this.i64out, 0, 8);
    }

    @Override
    public void writeFloat(float value) throws TException {
        this.writeI32(Float.floatToIntBits(value));
    }

    @Override
    public void writeDouble(double value) throws TException {
        this.writeI64(Double.doubleToLongBits(value));
    }

    @Override
    public void writeString(String value) throws TException {
        byte[] dat = value.getBytes(StandardCharsets.UTF_8);
        this.writeI32(dat.length);
        this.transport.write(dat);
    }

    @Override
    public void writeBinary(ByteBuffer value) throws TException {
        int length = value.limit() - value.position();
        this.writeI32(length);
        this.transport.write(value.array(), value.position() + value.arrayOffset(), length);
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        int size = this.readI32();
        if (size < 0) {
            int version = size & 0xFFFF0000;
            if (version != -2147418112) {
                throw new TProtocolException("Bad version in readMessageBegin: " + version);
            }
            return new TMessage(this.readString(), (byte)(size & 0xFF), this.readI32());
        }
        return new TMessage(this.readStringBody(size), this.readByte(), this.readI32());
    }

    @Override
    public void readMessageEnd() {
    }

    @Override
    public TStruct readStructBegin() {
        return ANONYMOUS_STRUCT;
    }

    @Override
    public void readStructEnd() {
    }

    @Override
    public TField readFieldBegin() throws TException {
        byte type = this.readByte();
        short id = type == 0 ? (short)0 : this.readI16();
        return new TField("", type, id);
    }

    @Override
    public void readFieldEnd() {
    }

    @Override
    public TMap readMapBegin() throws TException {
        TMap map = new TMap(this.readByte(), this.readByte(), this.readI32());
        TBinaryProtocol.checkSize(map.getSize());
        return map;
    }

    @Override
    public void readMapEnd() {
    }

    @Override
    public TList readListBegin() throws TException {
        TList list = new TList(this.readByte(), this.readI32());
        TBinaryProtocol.checkSize(list.getSize());
        return list;
    }

    @Override
    public void readListEnd() {
    }

    @Override
    public TSet readSetBegin() throws TException {
        TSet set = new TSet(this.readByte(), this.readI32());
        TBinaryProtocol.checkSize(set.getSize());
        return set;
    }

    @Override
    public void readSetEnd() {
    }

    @Override
    public boolean readBool() throws TException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws TException {
        this.readAll(this.bin, 1);
        return this.bin[0];
    }

    @Override
    public short readI16() throws TException {
        byte[] buf = this.i16rd;
        int off = 0;
        this.readAll(this.i16rd, 2);
        return (short)((buf[off] & 0xFF) << 8 | buf[off + 1] & 0xFF);
    }

    @Override
    public int readI32() throws TException {
        byte[] buf = this.i32rd;
        int off = 0;
        this.readAll(this.i32rd, 4);
        return (buf[off] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    @Override
    public long readI64() throws TException {
        byte[] buf = this.i64rd;
        int off = 0;
        this.readAll(this.i64rd, 8);
        return (long)(buf[off] & 0xFF) << 56 | (long)(buf[off + 1] & 0xFF) << 48 | (long)(buf[off + 2] & 0xFF) << 40 | (long)(buf[off + 3] & 0xFF) << 32 | (long)(buf[off + 4] & 0xFF) << 24 | (long)(buf[off + 5] & 0xFF) << 16 | (long)(buf[off + 6] & 0xFF) << 8 | (long)(buf[off + 7] & 0xFF);
    }

    @Override
    public float readFloat() throws TException {
        return Float.intBitsToFloat(this.readI32());
    }

    @Override
    public double readDouble() throws TException {
        return Double.longBitsToDouble(this.readI64());
    }

    @Override
    public String readString() throws TException {
        int size = TBinaryProtocol.checkSize(this.readI32());
        return this.readStringBody(size);
    }

    public String readStringBody(int size) throws TException {
        byte[] buf = new byte[size];
        this.transport.read(buf, 0, size);
        return new String(buf, StandardCharsets.UTF_8);
    }

    @Override
    public ByteBuffer readBinary() throws TException {
        int size = TBinaryProtocol.checkSize(this.readI32());
        byte[] buf = new byte[size];
        this.transport.read(buf, 0, size);
        return ByteBuffer.wrap(buf);
    }

    @Override
    public int readBinary(byte[] buf, int offset) throws TException {
        int size = TBinaryProtocol.checkSize(this.readI32());
        Preconditions.checkArgument((buf.length - offset >= size ? 1 : 0) != 0, (Object)String.format("Binary is too large to be read into buffer: binary size: %s, buffer size: %s, buffer offset: %s", size, buf.length, offset));
        return TProtocolUtil.readAllInBatches(this.transport, buf, offset, size);
    }

    private static int checkSize(int length) throws TProtocolException {
        if (length < 0) {
            throw new TProtocolException("Negative length: " + length);
        }
        return length;
    }

    private void readAll(byte[] buf, int len) throws TException {
        this.transport.read(buf, 0, len);
    }
}

