/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.generic;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.drawee.drawable.FadeDrawable;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.MatrixDrawable;
import com.facebook.drawee.drawable.RoundedBitmapDrawable;
import com.facebook.drawee.drawable.RoundedColorDrawable;
import com.facebook.drawee.drawable.RoundedCornersDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.drawable.SettableDrawable;
import com.facebook.drawee.drawable.VisibilityAwareDrawable;
import com.facebook.drawee.drawable.VisibilityCallback;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.interfaces.SettableDraweeHierarchy;
import javax.annotation.Nullable;

public class GenericDraweeHierarchy
implements SettableDraweeHierarchy {
    private Drawable mEmptyPlaceholderDrawable;
    private final Drawable mEmptyActualImageDrawable = new ColorDrawable(0);
    private final Drawable mEmptyControllerOverlayDrawable = new ColorDrawable(0);
    private final Resources mResources;
    private final Drawable mTopLevelDrawable;
    private final FadeDrawable mFadeDrawable;
    private final SettableDrawable mActualImageSettableDrawable;
    private final int mPlaceholderImageIndex;
    private final int mProgressBarImageIndex;
    private final int mActualImageIndex;
    private final int mRetryImageIndex;
    private final int mFailureImageIndex;
    private final int mControllerOverlayIndex;
    private RoundingParams mRoundingParams;

    GenericDraweeHierarchy(GenericDraweeHierarchyBuilder builder) {
        int index;
        this.mResources = builder.getResources();
        this.mRoundingParams = builder.getRoundingParams();
        int numLayers = 0;
        int numBackgrounds = builder.getBackgrounds() != null ? builder.getBackgrounds().size() : 0;
        int backgroundsIndex = numLayers;
        numLayers += numBackgrounds;
        Drawable placeholderImageBranch = builder.getPlaceholderImage();
        if (placeholderImageBranch == null) {
            placeholderImageBranch = this.getEmptyPlaceholderDrawable();
        }
        placeholderImageBranch = GenericDraweeHierarchy.maybeApplyRounding(this.mRoundingParams, this.mResources, placeholderImageBranch);
        placeholderImageBranch = GenericDraweeHierarchy.maybeWrapWithScaleType(placeholderImageBranch, builder.getPlaceholderImageScaleType());
        this.mPlaceholderImageIndex = numLayers++;
        SettableDrawable actualImageBranch = null;
        actualImageBranch = this.mActualImageSettableDrawable = new SettableDrawable(this.mEmptyActualImageDrawable);
        actualImageBranch = GenericDraweeHierarchy.maybeWrapWithScaleType(actualImageBranch, builder.getActualImageScaleType(), builder.getActualImageFocusPoint());
        actualImageBranch = GenericDraweeHierarchy.maybeWrapWithMatrix(actualImageBranch, builder.getActualImageMatrix());
        actualImageBranch.setColorFilter(builder.getActualImageColorFilter());
        this.mActualImageIndex = numLayers++;
        Drawable progressBarImageBranch = builder.getProgressBarImage();
        if (progressBarImageBranch != null) {
            progressBarImageBranch = GenericDraweeHierarchy.maybeWrapWithScaleType(progressBarImageBranch, builder.getProgressBarImageScaleType());
            this.mProgressBarImageIndex = numLayers++;
        } else {
            this.mProgressBarImageIndex = -1;
        }
        Drawable retryImageBranch = builder.getRetryImage();
        if (retryImageBranch != null) {
            retryImageBranch = GenericDraweeHierarchy.maybeWrapWithScaleType(retryImageBranch, builder.getRetryImageScaleType());
            this.mRetryImageIndex = numLayers++;
        } else {
            this.mRetryImageIndex = -1;
        }
        Drawable failureImageBranch = builder.getFailureImage();
        if (failureImageBranch != null) {
            failureImageBranch = GenericDraweeHierarchy.maybeWrapWithScaleType(failureImageBranch, builder.getFailureImageScaleType());
            this.mFailureImageIndex = numLayers++;
        } else {
            this.mFailureImageIndex = -1;
        }
        int numOverlays = builder.getOverlays() != null ? builder.getOverlays().size() : 0;
        int overlaysIndex = numLayers;
        numLayers += numOverlays;
        numLayers += builder.getPressedStateOverlay() != null ? 1 : 0;
        this.mControllerOverlayIndex = numLayers++;
        Drawable[] layers = new Drawable[numLayers];
        if (numBackgrounds > 0) {
            index = 0;
            for (Drawable background : builder.getBackgrounds()) {
                layers[backgroundsIndex + index++] = background;
            }
        }
        if (this.mPlaceholderImageIndex >= 0) {
            layers[this.mPlaceholderImageIndex] = placeholderImageBranch;
        }
        if (this.mActualImageIndex >= 0) {
            layers[this.mActualImageIndex] = actualImageBranch;
        }
        if (this.mProgressBarImageIndex >= 0) {
            layers[this.mProgressBarImageIndex] = progressBarImageBranch;
        }
        if (this.mRetryImageIndex >= 0) {
            layers[this.mRetryImageIndex] = retryImageBranch;
        }
        if (this.mFailureImageIndex >= 0) {
            layers[this.mFailureImageIndex] = failureImageBranch;
        }
        if (numOverlays > 0) {
            index = 0;
            for (Drawable overlay : builder.getOverlays()) {
                layers[overlaysIndex + index++] = overlay;
            }
            if (builder.getPressedStateOverlay() != null) {
                layers[overlaysIndex + index++] = builder.getPressedStateOverlay();
            }
        }
        if (this.mControllerOverlayIndex >= 0) {
            layers[this.mControllerOverlayIndex] = this.mEmptyControllerOverlayDrawable;
        }
        this.mFadeDrawable = new RootFadeDrawable(layers);
        this.mFadeDrawable.setTransitionDuration(builder.getFadeDuration());
        FadeDrawable root = this.mFadeDrawable;
        root = GenericDraweeHierarchy.maybeWrapWithRoundedCorners(this.mRoundingParams, root);
        this.mTopLevelDrawable = root;
        this.mTopLevelDrawable.mutate();
        this.resetFade();
    }

    private static Drawable maybeWrapWithScaleType(Drawable drawable, @Nullable ScalingUtils.ScaleType scaleType) {
        return GenericDraweeHierarchy.maybeWrapWithScaleType(drawable, scaleType, null);
    }

    private static Drawable maybeWrapWithScaleType(Drawable drawable, @Nullable ScalingUtils.ScaleType scaleType, @Nullable PointF focusPoint) {
        Preconditions.checkNotNull((Object)drawable);
        if (scaleType == null) {
            return drawable;
        }
        ScaleTypeDrawable scaleTypeDrawable = new ScaleTypeDrawable(drawable, scaleType);
        if (focusPoint != null) {
            scaleTypeDrawable.setFocusPoint(focusPoint);
        }
        return scaleTypeDrawable;
    }

    private static Drawable maybeWrapWithMatrix(Drawable drawable, @Nullable Matrix matrix) {
        Preconditions.checkNotNull((Object)drawable);
        if (matrix == null) {
            return drawable;
        }
        return new MatrixDrawable(drawable, matrix);
    }

    private static Drawable maybeWrapWithRoundedCorners(@Nullable RoundingParams roundingParams, Drawable drawable) {
        if (roundingParams != null && roundingParams.getRoundingMethod() == RoundingParams.RoundingMethod.OVERLAY_COLOR) {
            RoundedCornersDrawable roundedCornersDrawable = new RoundedCornersDrawable(drawable);
            roundedCornersDrawable.setCircle(roundingParams.getRoundAsCircle());
            roundedCornersDrawable.setRadii(roundingParams.getCornersRadii());
            roundedCornersDrawable.setOverlayColor(roundingParams.getOverlayColor());
            roundedCornersDrawable.setBorder(roundingParams.getBorderColor(), roundingParams.getBorderWidth());
            return roundedCornersDrawable;
        }
        return drawable;
    }

    private static Drawable maybeApplyRounding(@Nullable RoundingParams roundingParams, Resources resources, Drawable drawable) {
        if (roundingParams != null && roundingParams.getRoundingMethod() == RoundingParams.RoundingMethod.BITMAP_ONLY) {
            if (drawable instanceof BitmapDrawable) {
                RoundedBitmapDrawable roundedBitmapDrawable = RoundedBitmapDrawable.fromBitmapDrawable(resources, (BitmapDrawable)drawable);
                roundedBitmapDrawable.setCircle(roundingParams.getRoundAsCircle());
                roundedBitmapDrawable.setCornerRadii(roundingParams.getCornersRadii());
                roundedBitmapDrawable.setBorder(roundingParams.getBorderColor(), roundingParams.getBorderWidth());
                return roundedBitmapDrawable;
            }
            if (drawable instanceof ColorDrawable && Build.VERSION.SDK_INT >= 11) {
                RoundedColorDrawable roundedColorDrawable = RoundedColorDrawable.fromColorDrawable((ColorDrawable)drawable);
                roundedColorDrawable.setCircle(roundingParams.getRoundAsCircle());
                roundedColorDrawable.setRadii(roundingParams.getCornersRadii());
                roundedColorDrawable.setBorder(roundingParams.getBorderColor(), roundingParams.getBorderWidth());
                return roundedColorDrawable;
            }
        }
        return drawable;
    }

    private void resetActualImages() {
        if (this.mActualImageSettableDrawable != null) {
            this.mActualImageSettableDrawable.setDrawable(this.mEmptyActualImageDrawable);
        }
    }

    private void resetFade() {
        if (this.mFadeDrawable != null) {
            this.mFadeDrawable.beginBatchMode();
            this.mFadeDrawable.fadeInAllLayers();
            this.fadeOutBranches();
            this.fadeInLayer(this.mPlaceholderImageIndex);
            this.mFadeDrawable.finishTransitionImmediately();
            this.mFadeDrawable.endBatchMode();
        }
    }

    private void fadeOutBranches() {
        this.fadeOutLayer(this.mPlaceholderImageIndex);
        this.fadeOutLayer(this.mActualImageIndex);
        this.fadeOutLayer(this.mProgressBarImageIndex);
        this.fadeOutLayer(this.mRetryImageIndex);
        this.fadeOutLayer(this.mFailureImageIndex);
    }

    private void fadeInLayer(int index) {
        if (index >= 0) {
            this.mFadeDrawable.fadeInLayer(index);
        }
    }

    private void fadeOutLayer(int index) {
        if (index >= 0) {
            this.mFadeDrawable.fadeOutLayer(index);
        }
    }

    private void setProgress(int progress) {
        if (progress == 100) {
            this.fadeOutLayer(this.mProgressBarImageIndex);
        } else {
            this.fadeInLayer(this.mProgressBarImageIndex);
        }
    }

    @Override
    public Drawable getTopLevelDrawable() {
        return this.mTopLevelDrawable;
    }

    @Override
    public void reset() {
        this.resetActualImages();
        this.resetFade();
    }

    @Override
    public void setImage(Drawable drawable, boolean immediate, int progress) {
        drawable = GenericDraweeHierarchy.maybeApplyRounding(this.mRoundingParams, this.mResources, drawable);
        drawable.mutate();
        this.mActualImageSettableDrawable.setDrawable(drawable);
        this.mFadeDrawable.beginBatchMode();
        this.fadeOutBranches();
        this.fadeInLayer(this.mActualImageIndex);
        this.setProgress(progress);
        if (immediate) {
            this.mFadeDrawable.finishTransitionImmediately();
        }
        this.mFadeDrawable.endBatchMode();
    }

    @Override
    public void setProgress(int progress, boolean immediate) {
        this.mFadeDrawable.beginBatchMode();
        this.setProgress(progress);
        if (immediate) {
            this.mFadeDrawable.finishTransitionImmediately();
        }
        this.mFadeDrawable.endBatchMode();
    }

    @Override
    public void setFailure(Throwable throwable) {
        this.mFadeDrawable.beginBatchMode();
        this.fadeOutBranches();
        if (this.mFailureImageIndex >= 0) {
            this.fadeInLayer(this.mFailureImageIndex);
        } else {
            this.fadeInLayer(this.mPlaceholderImageIndex);
        }
        this.mFadeDrawable.endBatchMode();
    }

    @Override
    public void setRetry(Throwable throwable) {
        this.mFadeDrawable.beginBatchMode();
        this.fadeOutBranches();
        if (this.mRetryImageIndex >= 0) {
            this.fadeInLayer(this.mRetryImageIndex);
        } else {
            this.fadeInLayer(this.mPlaceholderImageIndex);
        }
        this.mFadeDrawable.endBatchMode();
    }

    @Override
    public void setControllerOverlay(@Nullable Drawable drawable) {
        if (drawable == null) {
            drawable = this.mEmptyControllerOverlayDrawable;
        }
        this.mFadeDrawable.setDrawable(this.mControllerOverlayIndex, drawable);
    }

    private Drawable findLayerParent(int index) {
        FadeDrawable parent = this.mFadeDrawable;
        Drawable child = this.mFadeDrawable.getDrawable(index);
        if (child instanceof MatrixDrawable) {
            parent = child;
            child = parent.getCurrent();
        }
        if (child instanceof ScaleTypeDrawable) {
            parent = child;
            child = parent.getCurrent();
        }
        return parent;
    }

    @Nullable
    private ScaleTypeDrawable findLayerScaleTypeDrawable(int index) {
        Drawable drawable = this.mFadeDrawable.getDrawable(index);
        if (drawable instanceof MatrixDrawable) {
            drawable = drawable.getCurrent();
        }
        if (drawable instanceof ScaleTypeDrawable) {
            return (ScaleTypeDrawable)drawable;
        }
        return null;
    }

    private void setLayerChildDrawable(int index, Drawable drawable) {
        Drawable parent = this.findLayerParent(index);
        if (parent == this.mFadeDrawable) {
            this.mFadeDrawable.setDrawable(index, drawable);
        } else {
            ((ForwardingDrawable)parent).setCurrent(drawable);
        }
    }

    private Drawable getEmptyPlaceholderDrawable() {
        if (this.mEmptyPlaceholderDrawable == null) {
            this.mEmptyPlaceholderDrawable = new ColorDrawable(0);
        }
        return this.mEmptyPlaceholderDrawable;
    }

    public void setActualImageFocusPoint(PointF focusPoint) {
        Preconditions.checkNotNull((Object)focusPoint);
        ScaleTypeDrawable scaleTypeDrawable = this.findLayerScaleTypeDrawable(this.mActualImageIndex);
        if (scaleTypeDrawable == null) {
            throw new UnsupportedOperationException("ScaleTypeDrawable not found!");
        }
        scaleTypeDrawable.setFocusPoint(focusPoint);
    }

    public void setActualImageScaleType(ScalingUtils.ScaleType scaleType) {
        Preconditions.checkNotNull((Object)((Object)scaleType));
        ScaleTypeDrawable scaleTypeDrawable = this.findLayerScaleTypeDrawable(this.mActualImageIndex);
        if (scaleTypeDrawable == null) {
            throw new UnsupportedOperationException("ScaleTypeDrawable not found!");
        }
        scaleTypeDrawable.setScaleType(scaleType);
    }

    public void setActualImageColorFilter(ColorFilter colorfilter) {
        this.mFadeDrawable.getDrawable(this.mActualImageIndex).setColorFilter(colorfilter);
    }

    public void getActualImageBounds(RectF outBounds) {
        this.mActualImageSettableDrawable.getTransformedBounds(outBounds);
    }

    public void setPlaceholderImage(Drawable drawable) {
        if (drawable == null) {
            drawable = this.getEmptyPlaceholderDrawable();
        }
        drawable = GenericDraweeHierarchy.maybeApplyRounding(this.mRoundingParams, this.mResources, drawable);
        this.setLayerChildDrawable(this.mPlaceholderImageIndex, drawable);
    }

    public void setPlaceholderImage(int resourceId) {
        this.setPlaceholderImage(this.mResources.getDrawable(resourceId));
    }

    public void setRoundingParams(RoundingParams roundingParams) {
        Preconditions.checkState((this.mRoundingParams != null && roundingParams != null && roundingParams.getRoundingMethod() == this.mRoundingParams.getRoundingMethod() ? 1 : 0) != 0, (Object)"Rounding method cannot be changed and it has to be set during construction time.");
        this.mRoundingParams = roundingParams;
        if (roundingParams.getRoundingMethod() == RoundingParams.RoundingMethod.OVERLAY_COLOR) {
            RoundedCornersDrawable roundedCornersDrawable = (RoundedCornersDrawable)this.mTopLevelDrawable;
            roundedCornersDrawable.setCircle(roundingParams.getRoundAsCircle());
            roundedCornersDrawable.setRadii(roundingParams.getCornersRadii());
            roundedCornersDrawable.setOverlayColor(roundingParams.getOverlayColor());
            roundedCornersDrawable.setBorder(roundingParams.getBorderColor(), roundingParams.getBorderWidth());
        }
    }

    public RoundingParams getRoundingParams() {
        return this.mRoundingParams;
    }

    private static class RootFadeDrawable
    extends FadeDrawable
    implements VisibilityAwareDrawable {
        @Nullable
        private VisibilityCallback mVisibilityCallback;

        public RootFadeDrawable(Drawable[] layers) {
            super(layers);
        }

        @Override
        public int getIntrinsicWidth() {
            return -1;
        }

        @Override
        public int getIntrinsicHeight() {
            return -1;
        }

        @Override
        public void setVisibilityCallback(@Nullable VisibilityCallback visibilityCallback) {
            this.mVisibilityCallback = visibilityCallback;
        }

        @Override
        public boolean setVisible(boolean visible, boolean restart) {
            if (this.mVisibilityCallback != null) {
                this.mVisibilityCallback.onVisibilityChange(visible);
            }
            return super.setVisible(visible, restart);
        }

        @Override
        public void draw(Canvas canvas) {
            if (this.mVisibilityCallback != null) {
                this.mVisibilityCallback.onDraw();
            }
            super.draw(canvas);
        }
    }
}

