/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.drawee.drawable.DrawableUtils;
import com.facebook.drawee.drawable.LightBitmapDrawable;
import com.facebook.drawee.drawable.Rounded;
import com.facebook.drawee.drawable.TransformAwareDrawable;
import com.facebook.drawee.drawable.TransformCallback;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.annotation.Nullable;

public class RoundedLightBitmapDrawable
extends LightBitmapDrawable
implements TransformAwareDrawable,
Rounded {
    private boolean mIsCircle = false;
    private boolean mRadiiNonZero = false;
    private final float[] mCornerRadii = new float[8];
    @VisibleForTesting
    final float[] mBorderRadii = new float[8];
    @VisibleForTesting
    final RectF mRootBounds = new RectF();
    @VisibleForTesting
    final RectF mPrevRootBounds = new RectF();
    @VisibleForTesting
    final RectF mBitmapBounds = new RectF();
    @VisibleForTesting
    final RectF mDrawableBounds = new RectF();
    @VisibleForTesting
    final Matrix mBoundsTransform = new Matrix();
    @VisibleForTesting
    final Matrix mPrevBoundsTransform = new Matrix();
    @VisibleForTesting
    final Matrix mParentTransform = new Matrix();
    @VisibleForTesting
    final Matrix mPrevParentTransform = new Matrix();
    @VisibleForTesting
    final Matrix mInverseParentTransform = new Matrix();
    @VisibleForTesting
    final Matrix mTransform = new Matrix();
    private float mBorderWidth = 0.0f;
    private int mBorderColor = 0;
    private float mPadding = 0.0f;
    private final Path mPath = new Path();
    private final Path mBorderPath = new Path();
    private boolean mIsPathDirty = true;
    private final Paint mBorderPaint = new Paint(1);
    private boolean mIsShaderTransformDirty = true;
    private WeakReference<Bitmap> mLastBitmap;
    private Shader mShader;
    @Nullable
    private TransformCallback mTransformCallback;

    public RoundedLightBitmapDrawable(Resources res, Bitmap bitmap) {
        this(res, bitmap, null);
    }

    public RoundedLightBitmapDrawable(Resources res, Bitmap bitmap, @Nullable Paint paint) {
        super(res, bitmap, paint);
        this.getPaint().setFlags(1);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public void setCircle(boolean isCircle) {
        this.mIsCircle = isCircle;
        this.mIsPathDirty = true;
        this.invalidateSelf();
    }

    @Override
    public boolean isCircle() {
        return this.mIsCircle;
    }

    @Override
    public void setRadius(float radius) {
        Preconditions.checkState((radius >= 0.0f ? 1 : 0) != 0);
        Arrays.fill(this.mCornerRadii, radius);
        this.mRadiiNonZero = radius != 0.0f;
        this.mIsPathDirty = true;
        this.invalidateSelf();
    }

    @Override
    public void setRadii(float[] radii) {
        if (radii == null) {
            Arrays.fill(this.mCornerRadii, 0.0f);
            this.mRadiiNonZero = false;
        } else {
            Preconditions.checkArgument((radii.length == 8 ? 1 : 0) != 0, (Object)"radii should have exactly 8 values");
            System.arraycopy(radii, 0, this.mCornerRadii, 0, 8);
            this.mRadiiNonZero = false;
            for (int i = 0; i < 8; ++i) {
                this.mRadiiNonZero |= radii[i] > 0.0f;
            }
        }
        this.mIsPathDirty = true;
        this.invalidateSelf();
    }

    @Override
    public float[] getRadii() {
        return this.mCornerRadii;
    }

    @Override
    public void setBorder(int color, float width) {
        if (this.mBorderColor != color || this.mBorderWidth != width) {
            this.mBorderColor = color;
            this.mBorderWidth = width;
            this.mIsPathDirty = true;
            this.invalidateSelf();
        }
    }

    @Override
    public int getBorderColor() {
        return this.mBorderColor;
    }

    @Override
    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    @Override
    public void setPadding(float padding) {
        if (this.mPadding != padding) {
            this.mPadding = padding;
            this.mIsPathDirty = true;
            this.invalidateSelf();
        }
    }

    @Override
    public float getPadding() {
        return this.mPadding;
    }

    @Override
    public void setTransformCallback(@Nullable TransformCallback transformCallback) {
        this.mTransformCallback = transformCallback;
    }

    @Override
    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        Bitmap bitmap = this.getBitmap();
        Paint paint = this.getPaint();
        if (bitmap == null) {
            return;
        }
        if (!this.shouldRound()) {
            paint.setShader(null);
            canvas.drawBitmap(bitmap, null, bounds, paint);
            return;
        }
        this.updatePaint(bitmap);
        this.updateTransform(bitmap, bounds);
        this.updatePath();
        int saveCount = canvas.save();
        canvas.concat(this.mInverseParentTransform);
        canvas.drawPath(this.mPath, this.getPaint());
        if (this.mBorderWidth > 0.0f) {
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
            this.mBorderPaint.setColor(DrawableUtils.multiplyColorAlpha(this.mBorderColor, this.getPaint().getAlpha()));
            canvas.drawPath(this.mBorderPath, this.mBorderPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    @VisibleForTesting
    boolean shouldRound() {
        return this.mIsCircle || this.mRadiiNonZero || this.mBorderWidth > 0.0f;
    }

    private void updateTransform(Bitmap bitmap, Rect bounds) {
        if (this.mTransformCallback != null) {
            this.mTransformCallback.getTransform(this.mParentTransform);
            this.mTransformCallback.getRootBounds(this.mRootBounds);
        } else {
            this.mParentTransform.reset();
            this.mRootBounds.set(bounds);
        }
        this.mBitmapBounds.set(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
        this.mDrawableBounds.set(bounds);
        this.mBoundsTransform.setRectToRect(this.mBitmapBounds, this.mDrawableBounds, Matrix.ScaleToFit.FILL);
        if (!this.mParentTransform.equals((Object)this.mPrevParentTransform) || !this.mBoundsTransform.equals((Object)this.mPrevBoundsTransform)) {
            this.mIsShaderTransformDirty = true;
            this.mParentTransform.invert(this.mInverseParentTransform);
            this.mTransform.set(this.mParentTransform);
            this.mTransform.preConcat(this.mBoundsTransform);
            this.mPrevParentTransform.set(this.mParentTransform);
            this.mPrevBoundsTransform.set(this.mBoundsTransform);
        }
        if (!this.mRootBounds.equals((Object)this.mPrevRootBounds)) {
            this.mIsPathDirty = true;
            this.mPrevRootBounds.set(this.mRootBounds);
        }
    }

    private void updatePath() {
        if (this.mIsPathDirty) {
            this.mBorderPath.reset();
            this.mRootBounds.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
            if (this.mIsCircle) {
                float radius = Math.min(this.mRootBounds.width(), this.mRootBounds.height()) / 2.0f;
                this.mBorderPath.addCircle(this.mRootBounds.centerX(), this.mRootBounds.centerY(), radius, Path.Direction.CW);
            } else {
                for (int i = 0; i < this.mBorderRadii.length; ++i) {
                    this.mBorderRadii[i] = this.mCornerRadii[i] + this.mPadding - this.mBorderWidth / 2.0f;
                }
                this.mBorderPath.addRoundRect(this.mRootBounds, this.mBorderRadii, Path.Direction.CW);
            }
            this.mRootBounds.inset(-this.mBorderWidth / 2.0f, -this.mBorderWidth / 2.0f);
            this.mPath.reset();
            this.mRootBounds.inset(this.mPadding, this.mPadding);
            if (this.mIsCircle) {
                this.mPath.addCircle(this.mRootBounds.centerX(), this.mRootBounds.centerY(), Math.min(this.mRootBounds.width(), this.mRootBounds.height()) / 2.0f, Path.Direction.CW);
            } else {
                this.mPath.addRoundRect(this.mRootBounds, this.mCornerRadii, Path.Direction.CW);
            }
            this.mRootBounds.inset(-this.mPadding, -this.mPadding);
            this.mPath.setFillType(Path.FillType.WINDING);
            this.mIsPathDirty = false;
        }
    }

    private void updatePaint(Bitmap bitmap) {
        Paint paint = this.getPaint();
        if (this.mLastBitmap == null || this.mLastBitmap.get() != bitmap) {
            this.mLastBitmap = new WeakReference<Bitmap>(bitmap);
            this.mShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mIsShaderTransformDirty = true;
        }
        if (this.mIsShaderTransformDirty) {
            this.mShader.setLocalMatrix(this.mTransform);
            this.mIsShaderTransformDirty = false;
        }
        if (paint.getShader() != this.mShader) {
            paint.setShader(this.mShader);
        }
    }

    @VisibleForTesting
    public Path getPath() {
        return this.mPath;
    }
}

