/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.controller;

import android.content.Context;
import android.graphics.drawable.Animatable;
import com.facebook.common.internal.Lists;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Supplier;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSources;
import com.facebook.datasource.FirstAvailableDataSourceSupplier;
import com.facebook.datasource.IncreasingQualityDataSourceSupplier;
import com.facebook.drawee.components.RetryManager;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.gestures.GestureDetector;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.SimpleDraweeControllerBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

public abstract class AbstractDraweeControllerBuilder<BUILDER extends AbstractDraweeControllerBuilder<BUILDER, REQUEST, IMAGE, INFO>, REQUEST, IMAGE, INFO>
implements SimpleDraweeControllerBuilder {
    private static final ControllerListener<Object> sAutoPlayAnimationsListener = new BaseControllerListener<Object>(){

        @Override
        public void onFinalImageSet(String id, @Nullable Object info, @Nullable Animatable anim) {
            if (anim != null) {
                anim.start();
            }
        }
    };
    private static final NullPointerException NO_REQUEST_EXCEPTION = new NullPointerException("No image request was specified!");
    private final Context mContext;
    private final Set<ControllerListener> mBoundControllerListeners;
    @Nullable
    private Object mCallerContext;
    @Nullable
    private REQUEST mImageRequest;
    @Nullable
    private REQUEST mLowResImageRequest;
    @Nullable
    private REQUEST[] mMultiImageRequests;
    @Nullable
    private Supplier<DataSource<IMAGE>> mDataSourceSupplier;
    @Nullable
    private ControllerListener<? super INFO> mControllerListener;
    private boolean mTapToRetryEnabled;
    private boolean mAutoPlayAnimations;
    @Nullable
    private DraweeController mOldController;
    private static final AtomicLong sIdCounter = new AtomicLong();

    protected AbstractDraweeControllerBuilder(Context context, Set<ControllerListener> boundControllerListeners) {
        this.mContext = context;
        this.mBoundControllerListeners = boundControllerListeners;
        this.init();
    }

    private void init() {
        this.mCallerContext = null;
        this.mImageRequest = null;
        this.mLowResImageRequest = null;
        this.mMultiImageRequests = null;
        this.mControllerListener = null;
        this.mTapToRetryEnabled = false;
        this.mAutoPlayAnimations = false;
        this.mOldController = null;
    }

    public BUILDER reset() {
        this.init();
        return this.getThis();
    }

    public BUILDER setCallerContext(Object callerContext) {
        this.mCallerContext = callerContext;
        return this.getThis();
    }

    @Nullable
    public Object getCallerContext() {
        return this.mCallerContext;
    }

    public BUILDER setImageRequest(REQUEST imageRequest) {
        this.mImageRequest = imageRequest;
        return this.getThis();
    }

    @Nullable
    public REQUEST getImageRequest() {
        return this.mImageRequest;
    }

    public BUILDER setLowResImageRequest(REQUEST lowResImageRequest) {
        this.mLowResImageRequest = lowResImageRequest;
        return this.getThis();
    }

    @Nullable
    public REQUEST getLowResImageRequest() {
        return this.mLowResImageRequest;
    }

    public BUILDER setFirstAvailableImageRequests(REQUEST[] firstAvailableImageRequests) {
        this.mMultiImageRequests = firstAvailableImageRequests;
        return this.getThis();
    }

    @Nullable
    public REQUEST[] getFirstAvailableImageRequests() {
        return this.mMultiImageRequests;
    }

    public void setDataSourceSupplier(@Nullable Supplier<DataSource<IMAGE>> dataSourceSupplier) {
        this.mDataSourceSupplier = dataSourceSupplier;
    }

    @Nullable
    public Supplier<DataSource<IMAGE>> getDataSourceSupplier() {
        return this.mDataSourceSupplier;
    }

    public BUILDER setTapToRetryEnabled(boolean enabled) {
        this.mTapToRetryEnabled = enabled;
        return this.getThis();
    }

    public boolean getTapToRetryEnabled() {
        return this.mTapToRetryEnabled;
    }

    public BUILDER setAutoPlayAnimations(boolean enabled) {
        this.mAutoPlayAnimations = enabled;
        return this.getThis();
    }

    public boolean getAutoPlayAnimations() {
        return this.mAutoPlayAnimations;
    }

    public BUILDER setControllerListener(ControllerListener<? super INFO> controllerListener) {
        this.mControllerListener = controllerListener;
        return this.getThis();
    }

    @Nullable
    public ControllerListener<? super INFO> getControllerListener() {
        return this.mControllerListener;
    }

    public BUILDER setOldController(@Nullable DraweeController oldController) {
        this.mOldController = oldController;
        return this.getThis();
    }

    @Nullable
    public DraweeController getOldController() {
        return this.mOldController;
    }

    @Override
    public AbstractDraweeController build() {
        this.validate();
        if (this.mImageRequest == null && this.mMultiImageRequests == null && this.mLowResImageRequest != null) {
            this.mImageRequest = this.mLowResImageRequest;
            this.mLowResImageRequest = null;
        }
        return this.buildController();
    }

    protected void validate() {
        Preconditions.checkState((this.mMultiImageRequests == null || this.mImageRequest == null ? 1 : 0) != 0, (Object)"Cannot specify both ImageRequest and FirstAvailableImageRequests!");
        Preconditions.checkState((this.mDataSourceSupplier == null || this.mMultiImageRequests == null && this.mImageRequest == null && this.mLowResImageRequest == null ? 1 : 0) != 0, (Object)"Cannot specify DataSourceSupplier with other ImageRequests! Use one or the other.");
    }

    protected AbstractDraweeController buildController() {
        AbstractDraweeController controller = this.obtainController();
        this.maybeBuildAndSetRetryManager(controller);
        this.maybeAttachListeners(controller);
        return controller;
    }

    protected static String generateUniqueControllerId() {
        return String.valueOf(sIdCounter.getAndIncrement());
    }

    protected Supplier<DataSource<IMAGE>> obtainDataSourceSupplier() {
        if (this.mDataSourceSupplier != null) {
            return this.mDataSourceSupplier;
        }
        Supplier supplier = null;
        if (this.mImageRequest != null) {
            supplier = this.getDataSourceSupplierForRequest(this.mImageRequest);
        } else if (this.mMultiImageRequests != null) {
            supplier = this.getFirstAvailableDataSourceSupplier(this.mMultiImageRequests);
        }
        if (supplier != null && this.mLowResImageRequest != null) {
            ArrayList suppliers = Lists.newArrayListWithCapacity((int)2);
            suppliers.add(supplier);
            suppliers.add(this.getDataSourceSupplierForRequest(this.mLowResImageRequest));
            supplier = IncreasingQualityDataSourceSupplier.create((List)suppliers);
        }
        if (supplier == null) {
            supplier = DataSources.getFailedDataSourceSupplier((Throwable)NO_REQUEST_EXCEPTION);
        }
        return supplier;
    }

    protected Supplier<DataSource<IMAGE>> getFirstAvailableDataSourceSupplier(REQUEST[] imageRequests) {
        int i;
        ArrayList suppliers = Lists.newArrayListWithCapacity((int)(imageRequests.length * 2));
        for (i = 0; i < imageRequests.length; ++i) {
            suppliers.add(this.getDataSourceSupplierForRequest(imageRequests[i], true));
        }
        for (i = 0; i < imageRequests.length; ++i) {
            suppliers.add(this.getDataSourceSupplierForRequest(imageRequests[i]));
        }
        return FirstAvailableDataSourceSupplier.create((List)suppliers);
    }

    protected Supplier<DataSource<IMAGE>> getDataSourceSupplierForRequest(REQUEST imageRequest) {
        return this.getDataSourceSupplierForRequest(imageRequest, false);
    }

    protected Supplier<DataSource<IMAGE>> getDataSourceSupplierForRequest(final REQUEST imageRequest, final boolean bitmapCacheOnly) {
        final Object callerContext = this.getCallerContext();
        return new Supplier<DataSource<IMAGE>>(){

            public DataSource<IMAGE> get() {
                return AbstractDraweeControllerBuilder.this.getDataSourceForRequest(imageRequest, callerContext, bitmapCacheOnly);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("request", (Object)imageRequest.toString()).toString();
            }
        };
    }

    protected void maybeAttachListeners(AbstractDraweeController controller) {
        if (this.mBoundControllerListeners != null) {
            for (ControllerListener listener : this.mBoundControllerListeners) {
                controller.addControllerListener(listener);
            }
        }
        if (this.mControllerListener != null) {
            controller.addControllerListener(this.mControllerListener);
        }
        if (this.mAutoPlayAnimations) {
            controller.addControllerListener(sAutoPlayAnimationsListener);
        }
    }

    protected void maybeBuildAndSetRetryManager(AbstractDraweeController controller) {
        if (!this.mTapToRetryEnabled) {
            return;
        }
        RetryManager retryManager = controller.getRetryManager();
        if (retryManager == null) {
            retryManager = new RetryManager();
            controller.setRetryManager(retryManager);
        }
        retryManager.setTapToRetryEnabled(this.mTapToRetryEnabled);
        this.maybeBuildAndSetGestureDetector(controller);
    }

    protected void maybeBuildAndSetGestureDetector(AbstractDraweeController controller) {
        GestureDetector gestureDetector = controller.getGestureDetector();
        if (gestureDetector == null) {
            gestureDetector = GestureDetector.newInstance(this.mContext);
            controller.setGestureDetector(gestureDetector);
        }
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected abstract AbstractDraweeController obtainController();

    protected abstract DataSource<IMAGE> getDataSourceForRequest(REQUEST var1, Object var2, boolean var3);

    protected abstract BUILDER getThis();
}

