/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.drawee.drawable.DrawableUtils;
import com.facebook.drawee.drawable.TransformAwareDrawable;
import com.facebook.drawee.drawable.TransformCallback;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.annotation.Nullable;

public class RoundedBitmapDrawable
extends BitmapDrawable
implements TransformAwareDrawable {
    @VisibleForTesting
    boolean mIsCircle = false;
    @VisibleForTesting
    float[] mCornerRadii = new float[8];
    @VisibleForTesting
    RectF mRootBounds = new RectF();
    @VisibleForTesting
    final RectF mLastRootBounds = new RectF();
    @VisibleForTesting
    final Matrix mTransform = new Matrix();
    @VisibleForTesting
    final Matrix mInverseTransform = new Matrix();
    @VisibleForTesting
    final Matrix mLastTransform = new Matrix();
    @VisibleForTesting
    float mBorderWidth = 0.0f;
    @VisibleForTesting
    int mBorderColor = 0;
    private final Path mPath = new Path();
    private boolean mIsPathDirty = true;
    private final Paint mPaint = new Paint(1);
    private final Paint mBorderPaint = new Paint(1);
    private boolean mIsShaderTransformDirty = true;
    private WeakReference<Bitmap> mLastBitmap;
    @Nullable
    private TransformCallback mTransformCallback;

    public RoundedBitmapDrawable(Resources res, Bitmap bitmap) {
        super(res, bitmap);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
    }

    public static RoundedBitmapDrawable fromBitmapDrawable(Resources res, BitmapDrawable bitmapDrawable) {
        return new RoundedBitmapDrawable(res, bitmapDrawable.getBitmap());
    }

    public void setCircle(boolean isCircle) {
        this.mIsCircle = isCircle;
        this.mIsPathDirty = true;
        this.invalidateSelf();
    }

    public void setCornerRadius(float radius) {
        Preconditions.checkState((radius >= 0.0f ? 1 : 0) != 0);
        Arrays.fill(this.mCornerRadii, radius);
        this.mIsPathDirty = true;
        this.invalidateSelf();
    }

    public void setCornerRadii(float[] radii) {
        if (radii == null) {
            Arrays.fill(this.mCornerRadii, 0.0f);
        } else {
            Preconditions.checkArgument((radii.length == 8 ? 1 : 0) != 0, (Object)"radii should have exactly 8 values");
            System.arraycopy(radii, 0, this.mCornerRadii, 0, 8);
        }
        this.mIsPathDirty = true;
        this.invalidateSelf();
    }

    public void setBorder(int color, float width) {
        if (this.mBorderColor != color || this.mBorderWidth != width) {
            this.mBorderColor = color;
            this.mBorderWidth = width;
            this.mIsPathDirty = true;
            this.invalidateSelf();
        }
    }

    @Override
    public void setTransformCallback(@Nullable TransformCallback transformCallback) {
        this.mTransformCallback = transformCallback;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mPaint.getAlpha()) {
            this.mPaint.setAlpha(alpha);
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        this.updateTransform();
        this.updatePath();
        this.updatePaint();
        int saveCount = canvas.save();
        canvas.concat(this.mInverseTransform);
        canvas.drawPath(this.mPath, this.mPaint);
        if (this.mBorderWidth != 0.0f) {
            this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
            this.mBorderPaint.setColor(DrawableUtils.multiplyColorAlpha(this.mBorderColor, this.mPaint.getAlpha()));
            canvas.drawPath(this.mPath, this.mBorderPaint);
        }
        canvas.restoreToCount(saveCount);
    }

    private void updateTransform() {
        if (this.mTransformCallback != null) {
            this.mTransformCallback.getTransform(this.mTransform);
            this.mTransformCallback.getRootBounds(this.mRootBounds);
        } else {
            this.mTransform.reset();
            this.mRootBounds.set(this.getBounds());
        }
        if (!this.mTransform.equals((Object)this.mLastTransform)) {
            this.mIsShaderTransformDirty = true;
            if (!this.mTransform.invert(this.mInverseTransform)) {
                this.mInverseTransform.reset();
                this.mTransform.reset();
            }
            this.mLastTransform.set(this.mTransform);
        }
        if (!this.mRootBounds.equals((Object)this.mLastRootBounds)) {
            this.mIsPathDirty = true;
            this.mLastRootBounds.set(this.mRootBounds);
        }
    }

    private void updatePath() {
        if (this.mIsPathDirty) {
            this.mPath.reset();
            this.mRootBounds.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
            if (this.mIsCircle) {
                this.mPath.addCircle(this.mRootBounds.centerX(), this.mRootBounds.centerY(), Math.min(this.mRootBounds.width(), this.mRootBounds.height()) / 2.0f, Path.Direction.CW);
            } else {
                this.mPath.addRoundRect(this.mRootBounds, this.mCornerRadii, Path.Direction.CW);
            }
            this.mRootBounds.inset(-(this.mBorderWidth / 2.0f), -(this.mBorderWidth / 2.0f));
            this.mPath.setFillType(Path.FillType.WINDING);
            this.mIsPathDirty = false;
        }
    }

    private void updatePaint() {
        Bitmap bitmap = this.getBitmap();
        if (this.mLastBitmap == null || this.mLastBitmap.get() != bitmap) {
            this.mLastBitmap = new WeakReference<Bitmap>(bitmap);
            this.mPaint.setShader((Shader)new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            this.mIsShaderTransformDirty = true;
        }
        if (this.mIsShaderTransformDirty) {
            this.mPaint.getShader().setLocalMatrix(this.mTransform);
            this.mIsShaderTransformDirty = false;
        }
    }
}

