/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;

public class OrientedBitmapDrawable
extends BitmapDrawable {
    private static final int UNKNOWN_ROTATION_ANGLE = -1;
    @VisibleForTesting
    final Matrix mRotationMatrix;
    private int mRotationAngle;

    public OrientedBitmapDrawable(Resources res, Bitmap bitmap, int rotationAngle) {
        super(res, bitmap);
        Preconditions.checkArgument((rotationAngle == -1 || rotationAngle % 90 == 0 ? 1 : 0) != 0);
        this.mRotationMatrix = new Matrix();
        this.mRotationAngle = rotationAngle;
    }

    public void draw(Canvas canvas) {
        Rect bounds = this.getBounds();
        if (this.mRotationAngle <= 0) {
            super.draw(canvas);
            return;
        }
        this.mRotationMatrix.setRotate((float)this.mRotationAngle, (float)bounds.centerX(), (float)bounds.centerY());
        int saveCount = canvas.save();
        canvas.concat(this.mRotationMatrix);
        super.draw(canvas);
        canvas.restoreToCount(saveCount);
    }
}

