/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.controller;

import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.components.DeferredReleaser;
import com.facebook.drawee.components.DraweeEventTracker;
import com.facebook.drawee.components.RetryManager;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.controller.ControllerListener;
import com.facebook.drawee.controller.ForwardingControllerListener;
import com.facebook.drawee.gestures.GestureDetector;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.interfaces.SettableDraweeHierarchy;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractDraweeController<T, INFO>
implements DraweeController,
DeferredReleaser.Releasable,
GestureDetector.ClickListener {
    private static final Class<?> TAG = AbstractDraweeController.class;
    private final DraweeEventTracker mEventTracker = new DraweeEventTracker();
    private final DeferredReleaser mDeferredReleaser;
    private final Executor mUiThreadImmediateExecutor;
    @Nullable
    private RetryManager mRetryManager;
    @Nullable
    private GestureDetector mGestureDetector;
    @Nullable
    private ControllerListener<INFO> mControllerListener;
    @Nullable
    private SettableDraweeHierarchy mSettableDraweeHierarchy;
    @Nullable
    private Drawable mControllerOverlay;
    private String mId;
    private Object mCallerContext;
    private boolean mIsAttached;
    private boolean mIsRequestSubmitted;
    private boolean mHasFetchFailed;
    private boolean mRetainImageOnFailure;
    @Nullable
    private DataSource<T> mDataSource;
    @Nullable
    private T mFetchedImage;
    @Nullable
    private Drawable mDrawable;

    public AbstractDraweeController(DeferredReleaser deferredReleaser, Executor uiThreadImmediateExecutor, String id, Object callerContext) {
        this.mDeferredReleaser = deferredReleaser;
        this.mUiThreadImmediateExecutor = uiThreadImmediateExecutor;
        this.init(id, callerContext, true);
    }

    protected void initialize(String id, Object callerContext) {
        this.init(id, callerContext, false);
    }

    private void init(String id, Object callerContext, boolean justConstructed) {
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_INIT_CONTROLLER);
        if (!justConstructed && this.mDeferredReleaser != null) {
            this.mDeferredReleaser.cancelDeferredRelease(this);
        }
        this.mIsAttached = false;
        this.releaseFetch();
        this.mRetainImageOnFailure = false;
        if (this.mRetryManager != null) {
            this.mRetryManager.init();
        }
        if (this.mGestureDetector != null) {
            this.mGestureDetector.init();
            this.mGestureDetector.setClickListener(this);
        }
        if (this.mControllerListener instanceof InternalForwardingListener) {
            ((InternalForwardingListener)this.mControllerListener).clearListeners();
        } else {
            this.mControllerListener = null;
        }
        if (this.mSettableDraweeHierarchy != null) {
            this.mSettableDraweeHierarchy.reset();
            this.mSettableDraweeHierarchy.setControllerOverlay(null);
            this.mSettableDraweeHierarchy = null;
        }
        this.mControllerOverlay = null;
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s -> %s: initialize", (Object)System.identityHashCode(this), (Object)this.mId, (Object)id);
        }
        this.mId = id;
        this.mCallerContext = callerContext;
    }

    @Override
    public void release() {
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_RELEASE_CONTROLLER);
        if (this.mRetryManager != null) {
            this.mRetryManager.reset();
        }
        if (this.mGestureDetector != null) {
            this.mGestureDetector.reset();
        }
        if (this.mSettableDraweeHierarchy != null) {
            this.mSettableDraweeHierarchy.reset();
        }
        this.releaseFetch();
    }

    private void releaseFetch() {
        boolean wasRequestSubmitted = this.mIsRequestSubmitted;
        this.mIsRequestSubmitted = false;
        this.mHasFetchFailed = false;
        if (this.mDataSource != null) {
            this.mDataSource.close();
            this.mDataSource = null;
        }
        if (this.mDrawable != null) {
            this.releaseDrawable(this.mDrawable);
        }
        this.mDrawable = null;
        if (this.mFetchedImage != null) {
            this.logMessageAndImage("release", this.mFetchedImage);
            this.releaseImage(this.mFetchedImage);
            this.mFetchedImage = null;
        }
        if (wasRequestSubmitted) {
            this.getControllerListener().onRelease(this.mId);
        }
    }

    public String getId() {
        return this.mId;
    }

    public Object getCallerContext() {
        return this.mCallerContext;
    }

    @Nullable
    protected RetryManager getRetryManager() {
        return this.mRetryManager;
    }

    protected void setRetryManager(@Nullable RetryManager retryManager) {
        this.mRetryManager = retryManager;
    }

    @Nullable
    protected GestureDetector getGestureDetector() {
        return this.mGestureDetector;
    }

    protected void setGestureDetector(@Nullable GestureDetector gestureDetector) {
        this.mGestureDetector = gestureDetector;
        if (this.mGestureDetector != null) {
            this.mGestureDetector.setClickListener(this);
        }
    }

    protected void setRetainImageOnFailure(boolean enabled) {
        this.mRetainImageOnFailure = enabled;
    }

    public void addControllerListener(ControllerListener<? super INFO> controllerListener) {
        Preconditions.checkNotNull(controllerListener);
        if (this.mControllerListener instanceof InternalForwardingListener) {
            ((InternalForwardingListener)this.mControllerListener).addListener(controllerListener);
            return;
        }
        if (this.mControllerListener != null) {
            this.mControllerListener = InternalForwardingListener.createInternal(this.mControllerListener, controllerListener);
            return;
        }
        this.mControllerListener = controllerListener;
    }

    public void removeControllerListener(ControllerListener<? super INFO> controllerListener) {
        Preconditions.checkNotNull(controllerListener);
        if (this.mControllerListener instanceof InternalForwardingListener) {
            ((InternalForwardingListener)this.mControllerListener).removeListener(controllerListener);
            return;
        }
        if (this.mControllerListener == controllerListener) {
            this.mControllerListener = null;
        }
    }

    protected ControllerListener<INFO> getControllerListener() {
        if (this.mControllerListener == null) {
            return BaseControllerListener.getNoOpListener();
        }
        return this.mControllerListener;
    }

    @Override
    @Nullable
    public DraweeHierarchy getHierarchy() {
        return this.mSettableDraweeHierarchy;
    }

    @Override
    public void setHierarchy(@Nullable DraweeHierarchy hierarchy) {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: setHierarchy: %s", (Object)System.identityHashCode(this), (Object)this.mId, (Object)hierarchy);
        }
        this.mEventTracker.recordEvent(hierarchy != null ? DraweeEventTracker.Event.ON_SET_HIERARCHY : DraweeEventTracker.Event.ON_CLEAR_HIERARCHY);
        if (this.mIsRequestSubmitted) {
            this.mDeferredReleaser.cancelDeferredRelease(this);
            this.release();
        }
        if (this.mSettableDraweeHierarchy != null) {
            this.mSettableDraweeHierarchy.setControllerOverlay(null);
            this.mSettableDraweeHierarchy = null;
        }
        if (hierarchy != null) {
            Preconditions.checkArgument((boolean)(hierarchy instanceof SettableDraweeHierarchy));
            this.mSettableDraweeHierarchy = (SettableDraweeHierarchy)hierarchy;
            this.mSettableDraweeHierarchy.setControllerOverlay(this.mControllerOverlay);
        }
    }

    protected void setControllerOverlay(@Nullable Drawable controllerOverlay) {
        this.mControllerOverlay = controllerOverlay;
        if (this.mSettableDraweeHierarchy != null) {
            this.mSettableDraweeHierarchy.setControllerOverlay(this.mControllerOverlay);
        }
    }

    @Nullable
    protected Drawable getControllerOverlay() {
        return this.mControllerOverlay;
    }

    @Override
    public void onAttach() {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: onAttach: %s", (Object)System.identityHashCode(this), (Object)this.mId, (Object)(this.mIsRequestSubmitted ? "request already submitted" : "request needs submit"));
        }
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_ATTACH_CONTROLLER);
        Preconditions.checkNotNull((Object)this.mSettableDraweeHierarchy);
        this.mDeferredReleaser.cancelDeferredRelease(this);
        this.mIsAttached = true;
        if (!this.mIsRequestSubmitted) {
            this.submitRequest();
        }
    }

    @Override
    public void onDetach() {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: onDetach", (Object)System.identityHashCode(this), (Object)this.mId);
        }
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_DETACH_CONTROLLER);
        this.mIsAttached = false;
        this.mDeferredReleaser.scheduleDeferredRelease(this);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: onTouchEvent %s", (Object)System.identityHashCode(this), (Object)this.mId, (Object)event);
        }
        if (this.mGestureDetector == null) {
            return false;
        }
        if (this.mGestureDetector.isCapturingGesture() || this.shouldHandleGesture()) {
            this.mGestureDetector.onTouchEvent(event);
            return true;
        }
        return false;
    }

    protected boolean shouldHandleGesture() {
        return this.shouldRetryOnTap();
    }

    private boolean shouldRetryOnTap() {
        return this.mHasFetchFailed && this.mRetryManager != null && this.mRetryManager.shouldRetryOnTap();
    }

    @Override
    public boolean onClick() {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: onClick", (Object)System.identityHashCode(this), (Object)this.mId);
        }
        if (this.shouldRetryOnTap()) {
            this.mRetryManager.notifyTapToRetry();
            this.mSettableDraweeHierarchy.reset();
            this.submitRequest();
            return true;
        }
        return false;
    }

    protected void submitRequest() {
        this.mEventTracker.recordEvent(DraweeEventTracker.Event.ON_DATASOURCE_SUBMIT);
        this.getControllerListener().onSubmit(this.mId, this.mCallerContext);
        this.mSettableDraweeHierarchy.setProgress(0.0f, true);
        this.mIsRequestSubmitted = true;
        this.mHasFetchFailed = false;
        this.mDataSource = this.getDataSource();
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: submitRequest: dataSource: %x", (Object)System.identityHashCode(this), (Object)this.mId, (Object)System.identityHashCode(this.mDataSource));
        }
        final String id = this.mId;
        final boolean wasImmediate = this.mDataSource.hasResult();
        BaseDataSubscriber dataSubscriber = new BaseDataSubscriber<T>(){

            public void onNewResultImpl(DataSource<T> dataSource) {
                boolean isFinished = dataSource.isFinished();
                float progress = dataSource.getProgress();
                Object image = dataSource.getResult();
                if (image != null) {
                    AbstractDraweeController.this.onNewResultInternal(id, dataSource, image, progress, isFinished, wasImmediate);
                } else if (isFinished) {
                    AbstractDraweeController.this.onFailureInternal(id, dataSource, new NullPointerException(), true);
                }
            }

            public void onFailureImpl(DataSource<T> dataSource) {
                AbstractDraweeController.this.onFailureInternal(id, dataSource, dataSource.getFailureCause(), true);
            }

            public void onProgressUpdate(DataSource<T> dataSource) {
                boolean isFinished = dataSource.isFinished();
                float progress = dataSource.getProgress();
                AbstractDraweeController.this.onProgressUpdateInternal(id, dataSource, progress, isFinished);
            }
        };
        this.mDataSource.subscribe((DataSubscriber)dataSubscriber, this.mUiThreadImmediateExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNewResultInternal(String id, DataSource<T> dataSource, @Nullable T image, float progress, boolean isFinished, boolean wasImmediate) {
        Drawable drawable;
        if (!this.isExpectedDataSource(id, dataSource)) {
            this.logMessageAndImage("ignore_old_datasource @ onNewResult", image);
            this.releaseImage(image);
            dataSource.close();
            return;
        }
        this.mEventTracker.recordEvent(isFinished ? DraweeEventTracker.Event.ON_DATASOURCE_RESULT : DraweeEventTracker.Event.ON_DATASOURCE_RESULT_INT);
        try {
            drawable = this.createDrawable(image);
        }
        catch (Exception exception) {
            this.logMessageAndImage("drawable_failed @ onNewResult", image);
            this.releaseImage(image);
            this.onFailureInternal(id, dataSource, exception, isFinished);
            return;
        }
        T previousImage = this.mFetchedImage;
        Drawable previousDrawable = this.mDrawable;
        this.mFetchedImage = image;
        this.mDrawable = drawable;
        try {
            if (isFinished) {
                this.logMessageAndImage("set_final_result @ onNewResult", image);
                this.mDataSource = null;
                this.mSettableDraweeHierarchy.setImage(drawable, 1.0f, wasImmediate);
                this.getControllerListener().onFinalImageSet(id, this.getImageInfo(image), this.getAnimatable());
            } else {
                this.logMessageAndImage("set_intermediate_result @ onNewResult", image);
                this.mSettableDraweeHierarchy.setImage(drawable, progress, wasImmediate);
                this.getControllerListener().onIntermediateImageSet(id, this.getImageInfo(image));
            }
        }
        finally {
            if (previousDrawable != null && previousDrawable != drawable) {
                this.releaseDrawable(previousDrawable);
            }
            if (previousImage != null && previousImage != image) {
                this.logMessageAndImage("release_previous_result @ onNewResult", previousImage);
                this.releaseImage(previousImage);
            }
        }
    }

    private void onFailureInternal(String id, DataSource<T> dataSource, Throwable throwable, boolean isFinished) {
        if (!this.isExpectedDataSource(id, dataSource)) {
            this.logMessageAndFailure("ignore_old_datasource @ onFailure", throwable);
            dataSource.close();
            return;
        }
        this.mEventTracker.recordEvent(isFinished ? DraweeEventTracker.Event.ON_DATASOURCE_FAILURE : DraweeEventTracker.Event.ON_DATASOURCE_FAILURE_INT);
        if (isFinished) {
            this.logMessageAndFailure("final_failed @ onFailure", throwable);
            this.mDataSource = null;
            this.mHasFetchFailed = true;
            if (this.mRetainImageOnFailure && this.mDrawable != null) {
                this.mSettableDraweeHierarchy.setImage(this.mDrawable, 1.0f, true);
            } else if (this.shouldRetryOnTap()) {
                this.mSettableDraweeHierarchy.setRetry(throwable);
            } else {
                this.mSettableDraweeHierarchy.setFailure(throwable);
            }
            this.getControllerListener().onFailure(this.mId, throwable);
        } else {
            this.logMessageAndFailure("intermediate_failed @ onFailure", throwable);
            this.getControllerListener().onIntermediateImageFailed(this.mId, throwable);
        }
    }

    private void onProgressUpdateInternal(String id, DataSource<T> dataSource, float progress, boolean isFinished) {
        if (!this.isExpectedDataSource(id, dataSource)) {
            this.logMessageAndFailure("ignore_old_datasource @ onProgress", null);
            dataSource.close();
            return;
        }
        if (!isFinished) {
            this.mSettableDraweeHierarchy.setProgress(progress, false);
        }
    }

    private boolean isExpectedDataSource(String id, DataSource<T> dataSource) {
        return id.equals(this.mId) && dataSource == this.mDataSource && this.mIsRequestSubmitted;
    }

    private void logMessageAndImage(String messageAndMethod, T image) {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: %s: image: %s %x", (Object[])new Object[]{System.identityHashCode(this), this.mId, messageAndMethod, this.getImageClass(image), this.getImageHash(image)});
        }
    }

    private void logMessageAndFailure(String messageAndMethod, Throwable throwable) {
        if (FLog.isLoggable((int)2)) {
            FLog.v(TAG, (String)"controller %x %s: %s: failure: %s", (Object)System.identityHashCode(this), (Object)this.mId, (Object)messageAndMethod, (Object)throwable);
        }
    }

    @Override
    @Nullable
    public Animatable getAnimatable() {
        return this.mDrawable instanceof Animatable ? (Animatable)this.mDrawable : null;
    }

    protected abstract DataSource<T> getDataSource();

    protected abstract Drawable createDrawable(T var1);

    @Nullable
    protected abstract INFO getImageInfo(T var1);

    protected String getImageClass(@Nullable T image) {
        return image != null ? image.getClass().getSimpleName() : "<null>";
    }

    protected int getImageHash(@Nullable T image) {
        return System.identityHashCode(image);
    }

    protected abstract void releaseImage(@Nullable T var1);

    protected abstract void releaseDrawable(@Nullable Drawable var1);

    public String toString() {
        return Objects.toStringHelper((Object)this).add("isAttached", this.mIsAttached).add("isRequestSubmitted", this.mIsRequestSubmitted).add("hasFetchFailed", this.mHasFetchFailed).add("fetchedImage", this.getImageHash(this.mFetchedImage)).add("events", (Object)this.mEventTracker.toString()).toString();
    }

    private static class InternalForwardingListener<INFO>
    extends ForwardingControllerListener<INFO> {
        private InternalForwardingListener() {
        }

        public static <INFO> InternalForwardingListener<INFO> createInternal(ControllerListener<? super INFO> listener1, ControllerListener<? super INFO> listener2) {
            InternalForwardingListener<Object> forwarder = new InternalForwardingListener<Object>();
            forwarder.addListener(listener1);
            forwarder.addListener(listener2);
            return forwarder;
        }
    }
}

