/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.generic;

import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import com.facebook.common.internal.Preconditions;
import com.facebook.drawee.drawable.DrawableParent;
import com.facebook.drawee.drawable.FadeDrawable;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.MatrixDrawable;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.generic.RootDrawable;
import com.facebook.drawee.generic.RoundingParams;
import com.facebook.drawee.generic.WrappingUtils;
import com.facebook.drawee.interfaces.SettableDraweeHierarchy;
import javax.annotation.Nullable;

public class GenericDraweeHierarchy
implements SettableDraweeHierarchy {
    private final Drawable mEmptyActualImageDrawable = new ColorDrawable(0);
    private final Resources mResources;
    private RoundingParams mRoundingParams;
    private final RootDrawable mTopLevelDrawable;
    private final FadeDrawable mFadeDrawable;
    private final ForwardingDrawable mActualImageWrapper;
    private final int mPlaceholderImageIndex;
    private final int mProgressBarImageIndex;
    private final int mActualImageIndex;
    private final int mRetryImageIndex;
    private final int mFailureImageIndex;

    GenericDraweeHierarchy(GenericDraweeHierarchyBuilder builder) {
        int index;
        int numLayers;
        this.mResources = builder.getResources();
        this.mRoundingParams = builder.getRoundingParams();
        this.mActualImageWrapper = new ForwardingDrawable(this.mEmptyActualImageDrawable);
        int numBackgrounds = builder.getBackgrounds() != null ? builder.getBackgrounds().size() : 0;
        int numOverlays = builder.getOverlays() != null ? builder.getOverlays().size() : 0;
        numOverlays += builder.getPressedStateOverlay() != null ? 1 : 0;
        int backgroundsIndex = numLayers = 0;
        numLayers += numBackgrounds;
        this.mPlaceholderImageIndex = numLayers++;
        this.mActualImageIndex = numLayers++;
        this.mProgressBarImageIndex = numLayers++;
        this.mRetryImageIndex = numLayers++;
        this.mFailureImageIndex = numLayers++;
        int overlaysIndex = numLayers;
        Drawable[] layers = new Drawable[numLayers += numOverlays];
        if (numBackgrounds > 0) {
            index = 0;
            for (Drawable background : builder.getBackgrounds()) {
                layers[backgroundsIndex + index++] = this.buildBranch(background, null);
            }
        }
        layers[this.mPlaceholderImageIndex] = this.buildBranch(builder.getPlaceholderImage(), builder.getPlaceholderImageScaleType());
        layers[this.mActualImageIndex] = this.buildActualImageBranch(this.mActualImageWrapper, builder.getActualImageScaleType(), builder.getActualImageFocusPoint(), builder.getActualImageMatrix(), builder.getActualImageColorFilter());
        layers[this.mProgressBarImageIndex] = this.buildBranch(builder.getProgressBarImage(), builder.getProgressBarImageScaleType());
        layers[this.mRetryImageIndex] = this.buildBranch(builder.getRetryImage(), builder.getRetryImageScaleType());
        layers[this.mFailureImageIndex] = this.buildBranch(builder.getFailureImage(), builder.getFailureImageScaleType());
        if (numOverlays > 0) {
            index = 0;
            if (builder.getOverlays() != null) {
                for (Drawable overlay : builder.getOverlays()) {
                    layers[overlaysIndex + index++] = this.buildBranch(overlay, null);
                }
            }
            if (builder.getPressedStateOverlay() != null) {
                layers[overlaysIndex + index] = this.buildBranch(builder.getPressedStateOverlay(), null);
            }
        }
        this.mFadeDrawable = new FadeDrawable(layers);
        this.mFadeDrawable.setTransitionDuration(builder.getFadeDuration());
        Drawable maybeRoundedDrawable = WrappingUtils.maybeWrapWithRoundedOverlayColor(this.mFadeDrawable, this.mRoundingParams);
        this.mTopLevelDrawable = new RootDrawable(maybeRoundedDrawable);
        this.mTopLevelDrawable.mutate();
        this.resetFade();
    }

    @Nullable
    private Drawable buildActualImageBranch(Drawable drawable, @Nullable ScalingUtils.ScaleType scaleType, @Nullable PointF focusPoint, @Nullable Matrix matrix, @Nullable ColorFilter colorFilter) {
        drawable.setColorFilter(colorFilter);
        drawable = WrappingUtils.maybeWrapWithScaleType(drawable, scaleType, focusPoint);
        drawable = WrappingUtils.maybeWrapWithMatrix(drawable, matrix);
        return drawable;
    }

    @Nullable
    private Drawable buildBranch(@Nullable Drawable drawable, @Nullable ScalingUtils.ScaleType scaleType) {
        drawable = WrappingUtils.maybeApplyLeafRounding(drawable, this.mRoundingParams, this.mResources);
        drawable = WrappingUtils.maybeWrapWithScaleType(drawable, scaleType);
        return drawable;
    }

    private void resetActualImages() {
        this.mActualImageWrapper.setDrawable(this.mEmptyActualImageDrawable);
    }

    private void resetFade() {
        if (this.mFadeDrawable != null) {
            this.mFadeDrawable.beginBatchMode();
            this.mFadeDrawable.fadeInAllLayers();
            this.fadeOutBranches();
            this.fadeInLayer(this.mPlaceholderImageIndex);
            this.mFadeDrawable.finishTransitionImmediately();
            this.mFadeDrawable.endBatchMode();
        }
    }

    private void fadeOutBranches() {
        this.fadeOutLayer(this.mPlaceholderImageIndex);
        this.fadeOutLayer(this.mActualImageIndex);
        this.fadeOutLayer(this.mProgressBarImageIndex);
        this.fadeOutLayer(this.mRetryImageIndex);
        this.fadeOutLayer(this.mFailureImageIndex);
    }

    private void fadeInLayer(int index) {
        if (index >= 0) {
            this.mFadeDrawable.fadeInLayer(index);
        }
    }

    private void fadeOutLayer(int index) {
        if (index >= 0) {
            this.mFadeDrawable.fadeOutLayer(index);
        }
    }

    private void setProgress(float progress) {
        Drawable progressBarDrawable = this.getLayerParentDrawable(this.mProgressBarImageIndex).getDrawable();
        if (progressBarDrawable == null) {
            return;
        }
        if (progress >= 0.999f) {
            if (progressBarDrawable instanceof Animatable) {
                ((Animatable)progressBarDrawable).stop();
            }
            this.fadeOutLayer(this.mProgressBarImageIndex);
        } else {
            if (progressBarDrawable instanceof Animatable) {
                ((Animatable)progressBarDrawable).start();
            }
            this.fadeInLayer(this.mProgressBarImageIndex);
        }
        progressBarDrawable.setLevel(Math.round(progress * 10000.0f));
    }

    @Override
    public Drawable getTopLevelDrawable() {
        return this.mTopLevelDrawable;
    }

    @Override
    public void reset() {
        this.resetActualImages();
        this.resetFade();
    }

    @Override
    public void setImage(Drawable drawable, float progress, boolean immediate) {
        drawable = WrappingUtils.maybeApplyLeafRounding(drawable, this.mRoundingParams, this.mResources);
        drawable.mutate();
        this.mActualImageWrapper.setDrawable(drawable);
        this.mFadeDrawable.beginBatchMode();
        this.fadeOutBranches();
        this.fadeInLayer(this.mActualImageIndex);
        this.setProgress(progress);
        if (immediate) {
            this.mFadeDrawable.finishTransitionImmediately();
        }
        this.mFadeDrawable.endBatchMode();
    }

    @Override
    public void setProgress(float progress, boolean immediate) {
        this.mFadeDrawable.beginBatchMode();
        this.setProgress(progress);
        if (immediate) {
            this.mFadeDrawable.finishTransitionImmediately();
        }
        this.mFadeDrawable.endBatchMode();
    }

    @Override
    public void setFailure(Throwable throwable) {
        this.mFadeDrawable.beginBatchMode();
        this.fadeOutBranches();
        if (this.mFadeDrawable.getDrawable(this.mFailureImageIndex) != null) {
            this.fadeInLayer(this.mFailureImageIndex);
        } else {
            this.fadeInLayer(this.mPlaceholderImageIndex);
        }
        this.mFadeDrawable.endBatchMode();
    }

    @Override
    public void setRetry(Throwable throwable) {
        this.mFadeDrawable.beginBatchMode();
        this.fadeOutBranches();
        if (this.mFadeDrawable.getDrawable(this.mRetryImageIndex) != null) {
            this.fadeInLayer(this.mRetryImageIndex);
        } else {
            this.fadeInLayer(this.mPlaceholderImageIndex);
        }
        this.mFadeDrawable.endBatchMode();
    }

    @Override
    public void setControllerOverlay(@Nullable Drawable drawable) {
        this.mTopLevelDrawable.setControllerOverlay(drawable);
    }

    private DrawableParent getLayerParentDrawable(int index) {
        DrawableParent parent = this.mFadeDrawable.getDrawableParentForIndex(index);
        if (parent.getDrawable() instanceof MatrixDrawable) {
            parent = (MatrixDrawable)parent.getDrawable();
        }
        if (parent.getDrawable() instanceof ScaleTypeDrawable) {
            parent = (ScaleTypeDrawable)parent.getDrawable();
        }
        return parent;
    }

    private void setLayerChildDrawable(int index, @Nullable Drawable drawable) {
        if (drawable == null) {
            this.mFadeDrawable.setDrawable(index, null);
            return;
        }
        drawable = WrappingUtils.maybeApplyLeafRounding(drawable, this.mRoundingParams, this.mResources);
        this.getLayerParentDrawable(index).setDrawable(drawable);
    }

    private ScaleTypeDrawable getLayerScaleTypeDrawable(int index) {
        DrawableParent parent = this.getLayerParentDrawable(index);
        if (parent instanceof ScaleTypeDrawable) {
            return (ScaleTypeDrawable)parent;
        }
        return WrappingUtils.wrapChildWithScaleType(parent, ScalingUtils.ScaleType.FIT_XY);
    }

    public void setFadeDuration(int durationMs) {
        this.mFadeDrawable.setTransitionDuration(durationMs);
    }

    public void setActualImageFocusPoint(PointF focusPoint) {
        Preconditions.checkNotNull((Object)focusPoint);
        this.getLayerScaleTypeDrawable(this.mActualImageIndex).setFocusPoint(focusPoint);
    }

    public void setActualImageScaleType(ScalingUtils.ScaleType scaleType) {
        Preconditions.checkNotNull((Object)((Object)scaleType));
        this.getLayerScaleTypeDrawable(this.mActualImageIndex).setScaleType(scaleType);
    }

    public void setActualImageColorFilter(ColorFilter colorfilter) {
        this.mActualImageWrapper.setColorFilter(colorfilter);
    }

    public void getActualImageBounds(RectF outBounds) {
        this.mActualImageWrapper.getTransformedBounds(outBounds);
    }

    public void setPlaceholderImage(@Nullable Drawable drawable) {
        this.setLayerChildDrawable(this.mPlaceholderImageIndex, drawable);
    }

    public void setPlaceholderImage(Drawable drawable, ScalingUtils.ScaleType scaleType) {
        this.setLayerChildDrawable(this.mPlaceholderImageIndex, drawable);
        this.getLayerScaleTypeDrawable(this.mPlaceholderImageIndex).setScaleType(scaleType);
    }

    public void setPlaceholderImageFocusPoint(PointF focusPoint) {
        Preconditions.checkNotNull((Object)focusPoint);
        this.getLayerScaleTypeDrawable(this.mPlaceholderImageIndex).setFocusPoint(focusPoint);
    }

    public void setPlaceholderImage(int resourceId) {
        this.setPlaceholderImage(this.mResources.getDrawable(resourceId));
    }

    public void setFailureImage(@Nullable Drawable drawable) {
        this.setLayerChildDrawable(this.mFailureImageIndex, drawable);
    }

    public void setFailureImage(Drawable drawable, ScalingUtils.ScaleType scaleType) {
        this.setLayerChildDrawable(this.mFailureImageIndex, drawable);
        this.getLayerScaleTypeDrawable(this.mFailureImageIndex).setScaleType(scaleType);
    }

    public void setRetryImage(@Nullable Drawable drawable) {
        this.setLayerChildDrawable(this.mRetryImageIndex, drawable);
    }

    public void setRetryImage(Drawable drawable, ScalingUtils.ScaleType scaleType) {
        this.setLayerChildDrawable(this.mRetryImageIndex, drawable);
        this.getLayerScaleTypeDrawable(this.mRetryImageIndex).setScaleType(scaleType);
    }

    public void setProgressBarImage(@Nullable Drawable drawable) {
        this.setLayerChildDrawable(this.mProgressBarImageIndex, drawable);
    }

    public void setProgressBarImage(Drawable drawable, ScalingUtils.ScaleType scaleType) {
        this.setLayerChildDrawable(this.mProgressBarImageIndex, drawable);
        this.getLayerScaleTypeDrawable(this.mProgressBarImageIndex).setScaleType(scaleType);
    }

    public void setRoundingParams(RoundingParams roundingParams) {
        this.mRoundingParams = roundingParams;
        WrappingUtils.updateOverlayColorRounding(this.mTopLevelDrawable, this.mRoundingParams);
        for (int i = 0; i < this.mFadeDrawable.getNumberOfLayers(); ++i) {
            WrappingUtils.updateLeafRounding(this.getLayerParentDrawable(i), this.mRoundingParams, this.mResources);
        }
    }

    public RoundingParams getRoundingParams() {
        return this.mRoundingParams;
    }
}

