/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.drawee.drawable.Rounded;
import com.facebook.drawee.drawable.TransformAwareDrawable;
import com.facebook.drawee.drawable.TransformCallback;
import java.util.Arrays;

public abstract class RoundedDrawable
extends Drawable
implements Rounded,
TransformAwareDrawable {
    private final Drawable mDelegate;
    protected boolean mIsCircle = false;
    protected boolean mRadiiNonZero = false;
    protected float mBorderWidth = 0.0f;
    protected final Path mPath = new Path();
    protected boolean mIsShaderTransformDirty = true;
    protected int mBorderColor = 0;
    protected final Path mBorderPath = new Path();
    private final float[] mCornerRadii = new float[8];
    @VisibleForTesting
    final float[] mBorderRadii = new float[8];
    @VisibleForTesting
    @Nullable
    float[] mInsideBorderRadii;
    @VisibleForTesting
    final RectF mRootBounds = new RectF();
    @VisibleForTesting
    final RectF mPrevRootBounds = new RectF();
    @VisibleForTesting
    final RectF mBitmapBounds = new RectF();
    @VisibleForTesting
    final RectF mDrawableBounds = new RectF();
    @VisibleForTesting
    @Nullable
    RectF mInsideBorderBounds;
    @VisibleForTesting
    final Matrix mBoundsTransform = new Matrix();
    @VisibleForTesting
    final Matrix mPrevBoundsTransform = new Matrix();
    @VisibleForTesting
    final Matrix mParentTransform = new Matrix();
    @VisibleForTesting
    final Matrix mPrevParentTransform = new Matrix();
    @VisibleForTesting
    final Matrix mInverseParentTransform = new Matrix();
    @VisibleForTesting
    @Nullable
    Matrix mInsideBorderTransform;
    @VisibleForTesting
    @Nullable
    Matrix mPrevInsideBorderTransform;
    @VisibleForTesting
    final Matrix mTransform = new Matrix();
    private float mPadding = 0.0f;
    private boolean mScaleDownInsideBorders = false;
    private boolean mIsPathDirty = true;
    @Nullable
    private TransformCallback mTransformCallback;

    RoundedDrawable(Drawable drawable) {
        this.mDelegate = drawable;
    }

    @Override
    public void setCircle(boolean isCircle) {
        this.mIsCircle = isCircle;
        this.mIsPathDirty = true;
        this.invalidateSelf();
    }

    @Override
    public boolean isCircle() {
        return this.mIsCircle;
    }

    @Override
    public void setRadius(float radius) {
        Preconditions.checkState((radius >= 0.0f ? 1 : 0) != 0);
        Arrays.fill(this.mCornerRadii, radius);
        this.mRadiiNonZero = radius != 0.0f;
        this.mIsPathDirty = true;
        this.invalidateSelf();
    }

    @Override
    public void setRadii(float[] radii) {
        if (radii == null) {
            Arrays.fill(this.mCornerRadii, 0.0f);
            this.mRadiiNonZero = false;
        } else {
            Preconditions.checkArgument((radii.length == 8 ? 1 : 0) != 0, (Object)"radii should have exactly 8 values");
            System.arraycopy(radii, 0, this.mCornerRadii, 0, 8);
            this.mRadiiNonZero = false;
            for (int i = 0; i < 8; ++i) {
                this.mRadiiNonZero |= radii[i] > 0.0f;
            }
        }
        this.mIsPathDirty = true;
        this.invalidateSelf();
    }

    @Override
    public float[] getRadii() {
        return this.mCornerRadii;
    }

    @Override
    public void setBorder(int color, float width) {
        if (this.mBorderColor != color || this.mBorderWidth != width) {
            this.mBorderColor = color;
            this.mBorderWidth = width;
            this.mIsPathDirty = true;
            this.invalidateSelf();
        }
    }

    @Override
    public int getBorderColor() {
        return this.mBorderColor;
    }

    @Override
    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    @Override
    public void setPadding(float padding) {
        if (this.mPadding != padding) {
            this.mPadding = padding;
            this.mIsPathDirty = true;
            this.invalidateSelf();
        }
    }

    @Override
    public float getPadding() {
        return this.mPadding;
    }

    @Override
    public void setScaleDownInsideBorders(boolean scaleDownInsideBorders) {
        if (this.mScaleDownInsideBorders != scaleDownInsideBorders) {
            this.mScaleDownInsideBorders = scaleDownInsideBorders;
            this.mIsPathDirty = true;
            this.invalidateSelf();
        }
    }

    @Override
    public boolean getScaleDownInsideBorders() {
        return this.mScaleDownInsideBorders;
    }

    @Override
    public void setTransformCallback(@Nullable TransformCallback transformCallback) {
        this.mTransformCallback = transformCallback;
    }

    protected void updateTransform() {
        if (this.mTransformCallback != null) {
            this.mTransformCallback.getTransform(this.mParentTransform);
            this.mTransformCallback.getRootBounds(this.mRootBounds);
        } else {
            this.mParentTransform.reset();
            this.mRootBounds.set(this.getBounds());
        }
        this.mBitmapBounds.set(0.0f, 0.0f, (float)this.getIntrinsicWidth(), (float)this.getIntrinsicHeight());
        this.mDrawableBounds.set(this.mDelegate.getBounds());
        this.mBoundsTransform.setRectToRect(this.mBitmapBounds, this.mDrawableBounds, Matrix.ScaleToFit.FILL);
        if (this.mScaleDownInsideBorders) {
            if (this.mInsideBorderBounds == null) {
                this.mInsideBorderBounds = new RectF(this.mRootBounds);
            } else {
                this.mInsideBorderBounds.set(this.mRootBounds);
            }
            this.mInsideBorderBounds.inset(this.mBorderWidth, this.mBorderWidth);
            if (this.mInsideBorderTransform == null) {
                this.mInsideBorderTransform = new Matrix();
            }
            this.mInsideBorderTransform.setRectToRect(this.mRootBounds, this.mInsideBorderBounds, Matrix.ScaleToFit.FILL);
        } else if (this.mInsideBorderTransform != null) {
            this.mInsideBorderTransform.reset();
        }
        if (!this.mParentTransform.equals((Object)this.mPrevParentTransform) || !this.mBoundsTransform.equals((Object)this.mPrevBoundsTransform) || this.mInsideBorderTransform != null && !this.mInsideBorderTransform.equals((Object)this.mPrevInsideBorderTransform)) {
            this.mIsShaderTransformDirty = true;
            this.mParentTransform.invert(this.mInverseParentTransform);
            this.mTransform.set(this.mParentTransform);
            if (this.mScaleDownInsideBorders) {
                this.mTransform.postConcat(this.mInsideBorderTransform);
            }
            this.mTransform.preConcat(this.mBoundsTransform);
            this.mPrevParentTransform.set(this.mParentTransform);
            this.mPrevBoundsTransform.set(this.mBoundsTransform);
            if (this.mScaleDownInsideBorders) {
                if (this.mPrevInsideBorderTransform == null) {
                    this.mPrevInsideBorderTransform = new Matrix(this.mInsideBorderTransform);
                } else {
                    this.mPrevInsideBorderTransform.set(this.mInsideBorderTransform);
                }
            } else if (this.mPrevInsideBorderTransform != null) {
                this.mPrevInsideBorderTransform.reset();
            }
        }
        if (!this.mRootBounds.equals((Object)this.mPrevRootBounds)) {
            this.mIsPathDirty = true;
            this.mPrevRootBounds.set(this.mRootBounds);
        }
    }

    protected void updatePath() {
        if (this.mIsPathDirty) {
            this.mBorderPath.reset();
            this.mRootBounds.inset(this.mBorderWidth / 2.0f, this.mBorderWidth / 2.0f);
            if (this.mIsCircle) {
                float radius = Math.min(this.mRootBounds.width(), this.mRootBounds.height()) / 2.0f;
                this.mBorderPath.addCircle(this.mRootBounds.centerX(), this.mRootBounds.centerY(), radius, Path.Direction.CW);
            } else {
                for (int i = 0; i < this.mBorderRadii.length; ++i) {
                    this.mBorderRadii[i] = this.mCornerRadii[i] + this.mPadding - this.mBorderWidth / 2.0f;
                }
                this.mBorderPath.addRoundRect(this.mRootBounds, this.mBorderRadii, Path.Direction.CW);
            }
            this.mRootBounds.inset(-this.mBorderWidth / 2.0f, -this.mBorderWidth / 2.0f);
            this.mPath.reset();
            float totalPadding = this.mPadding + (this.mScaleDownInsideBorders ? this.mBorderWidth : 0.0f);
            this.mRootBounds.inset(totalPadding, totalPadding);
            if (this.mIsCircle) {
                this.mPath.addCircle(this.mRootBounds.centerX(), this.mRootBounds.centerY(), Math.min(this.mRootBounds.width(), this.mRootBounds.height()) / 2.0f, Path.Direction.CW);
            } else if (this.mScaleDownInsideBorders) {
                if (this.mInsideBorderRadii == null) {
                    this.mInsideBorderRadii = new float[8];
                }
                for (int i = 0; i < this.mBorderRadii.length; ++i) {
                    this.mInsideBorderRadii[i] = this.mCornerRadii[i] - this.mBorderWidth;
                }
                this.mPath.addRoundRect(this.mRootBounds, this.mInsideBorderRadii, Path.Direction.CW);
            } else {
                this.mPath.addRoundRect(this.mRootBounds, this.mCornerRadii, Path.Direction.CW);
            }
            this.mRootBounds.inset(-totalPadding, -totalPadding);
            this.mPath.setFillType(Path.FillType.WINDING);
            this.mIsPathDirty = false;
        }
    }

    @VisibleForTesting
    boolean shouldRound() {
        return this.mIsCircle || this.mRadiiNonZero || this.mBorderWidth > 0.0f;
    }

    protected void onBoundsChange(Rect bounds) {
        this.mDelegate.setBounds(bounds);
    }

    public int getIntrinsicWidth() {
        return this.mDelegate.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.mDelegate.getIntrinsicHeight();
    }

    public int getOpacity() {
        return this.mDelegate.getOpacity();
    }

    public void setColorFilter(int color, @NonNull PorterDuff.Mode mode) {
        this.mDelegate.setColorFilter(color, mode);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mDelegate.setColorFilter(colorFilter);
    }

    @RequiresApi(api=21)
    @Nullable
    public ColorFilter getColorFilter() {
        return this.mDelegate.getColorFilter();
    }

    public void clearColorFilter() {
        this.mDelegate.clearColorFilter();
    }

    @RequiresApi(api=19)
    public int getAlpha() {
        return this.mDelegate.getAlpha();
    }

    public void setAlpha(int alpha) {
        this.mDelegate.setAlpha(alpha);
    }

    public void draw(@NonNull Canvas canvas) {
        this.mDelegate.draw(canvas);
    }
}

