/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.components;

import android.os.Looper;
import com.facebook.drawee.components.DeferredReleaserConcurrentImpl;
import com.facebook.drawee.components.DeferredReleaserLegacyImpl;
import javax.annotation.Nullable;

public abstract class DeferredReleaser {
    private static boolean useConcurrentImpl = false;
    @Nullable
    private static DeferredReleaser sInstance = null;

    public static void setUseConcurrentImpl(boolean useConcurrentImpl) {
        DeferredReleaser.useConcurrentImpl = useConcurrentImpl;
    }

    public static synchronized DeferredReleaser getInstance() {
        if (sInstance == null) {
            sInstance = useConcurrentImpl ? new DeferredReleaserConcurrentImpl() : new DeferredReleaserLegacyImpl();
        }
        return sInstance;
    }

    public abstract void scheduleDeferredRelease(Releasable var1);

    public abstract void cancelDeferredRelease(Releasable var1);

    static boolean isOnUiThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static interface Releasable {
        public void release();
    }
}

