/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.components;

import android.os.Handler;
import android.os.Looper;
import com.facebook.common.internal.Preconditions;
import com.facebook.drawee.components.DeferredReleaser;
import java.util.HashSet;
import java.util.Set;

class DeferredReleaserLegacyImpl
extends DeferredReleaser {
    protected final Set<DeferredReleaser.Releasable> mPendingReleasables;
    protected final Handler mUiHandler;
    private final Runnable releaseRunnable = new Runnable(){

        @Override
        public void run() {
            DeferredReleaserLegacyImpl.ensureOnUiThread();
            for (DeferredReleaser.Releasable releasable : DeferredReleaserLegacyImpl.this.mPendingReleasables) {
                releasable.release();
            }
            DeferredReleaserLegacyImpl.this.mPendingReleasables.clear();
        }
    };

    public DeferredReleaserLegacyImpl() {
        this.mPendingReleasables = new HashSet<DeferredReleaser.Releasable>();
        this.mUiHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void scheduleDeferredRelease(DeferredReleaser.Releasable releasable) {
        if (!DeferredReleaserLegacyImpl.isOnUiThread()) {
            releasable.release();
            return;
        }
        if (!this.mPendingReleasables.add(releasable)) {
            return;
        }
        if (this.mPendingReleasables.size() == 1) {
            this.mUiHandler.post(this.releaseRunnable);
        }
    }

    @Override
    public void cancelDeferredRelease(DeferredReleaser.Releasable releasable) {
        if (!DeferredReleaserLegacyImpl.isOnUiThread()) {
            return;
        }
        this.mPendingReleasables.remove(releasable);
    }

    private static void ensureOnUiThread() {
        Preconditions.checkState((boolean)DeferredReleaserLegacyImpl.isOnUiThread());
    }
}

