/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.facebook.drawee.drawable.ArrayDrawable;
import com.facebook.drawee.drawable.DrawableParent;
import com.facebook.drawee.drawable.ScaleTypeDrawable;
import javax.annotation.Nullable;

public class ScalingUtils {
    @Nullable
    public static ScaleTypeDrawable getActiveScaleTypeDrawable(@Nullable Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof ScaleTypeDrawable) {
            return (ScaleTypeDrawable)drawable;
        }
        if (drawable instanceof DrawableParent) {
            Drawable childDrawable = ((DrawableParent)drawable).getDrawable();
            return ScalingUtils.getActiveScaleTypeDrawable(childDrawable);
        }
        if (drawable instanceof ArrayDrawable) {
            ArrayDrawable fadeDrawable = (ArrayDrawable)drawable;
            int numLayers = fadeDrawable.getNumberOfLayers();
            for (int i = 0; i < numLayers; ++i) {
                Drawable childDrawable = fadeDrawable.getDrawable(i);
                ScaleTypeDrawable result = ScalingUtils.getActiveScaleTypeDrawable(childDrawable);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static class InterpolatingScaleType
    implements ScaleType,
    StatefulScaleType {
        private final ScaleType mScaleTypeFrom;
        private final ScaleType mScaleTypeTo;
        @Nullable
        private final Rect mBoundsFrom;
        @Nullable
        private final Rect mBoundsTo;
        @Nullable
        private final PointF mFocusPointFrom;
        @Nullable
        private final PointF mFocusPointTo;
        private final float[] mMatrixValuesFrom = new float[9];
        private final float[] mMatrixValuesTo = new float[9];
        private final float[] mMatrixValuesInterpolated = new float[9];
        private float mInterpolatingValue;

        public InterpolatingScaleType(ScaleType scaleTypeFrom, ScaleType scaleTypeTo, @Nullable Rect boundsFrom, @Nullable Rect boundsTo, @Nullable PointF focusPointFrom, @Nullable PointF focusPointTo) {
            this.mScaleTypeFrom = scaleTypeFrom;
            this.mScaleTypeTo = scaleTypeTo;
            this.mBoundsFrom = boundsFrom;
            this.mBoundsTo = boundsTo;
            this.mFocusPointFrom = focusPointFrom;
            this.mFocusPointTo = focusPointTo;
        }

        public InterpolatingScaleType(ScaleType scaleTypeFrom, ScaleType scaleTypeTo, @Nullable Rect boundsFrom, @Nullable Rect boundsTo) {
            this(scaleTypeFrom, scaleTypeTo, boundsFrom, boundsTo, null, null);
        }

        public InterpolatingScaleType(ScaleType scaleTypeFrom, ScaleType scaleTypeTo) {
            this(scaleTypeFrom, scaleTypeTo, null, null);
        }

        public ScaleType getScaleTypeFrom() {
            return this.mScaleTypeFrom;
        }

        public ScaleType getScaleTypeTo() {
            return this.mScaleTypeTo;
        }

        @Nullable
        public Rect getBoundsFrom() {
            return this.mBoundsFrom;
        }

        @Nullable
        public Rect getBoundsTo() {
            return this.mBoundsTo;
        }

        @Nullable
        public PointF getFocusPointFrom() {
            return this.mFocusPointFrom;
        }

        @Nullable
        public PointF getFocusPointTo() {
            return this.mFocusPointTo;
        }

        public void setValue(float value) {
            this.mInterpolatingValue = value;
        }

        public float getValue() {
            return this.mInterpolatingValue;
        }

        @Override
        public Object getState() {
            return Float.valueOf(this.mInterpolatingValue);
        }

        @Override
        public Matrix getTransform(Matrix transform, Rect parentBounds, int childWidth, int childHeight, float focusX, float focusY) {
            Rect boundsFrom = this.mBoundsFrom != null ? this.mBoundsFrom : parentBounds;
            Rect boundsTo = this.mBoundsTo != null ? this.mBoundsTo : parentBounds;
            this.mScaleTypeFrom.getTransform(transform, boundsFrom, childWidth, childHeight, this.mFocusPointFrom == null ? focusX : this.mFocusPointFrom.x, this.mFocusPointFrom == null ? focusY : this.mFocusPointFrom.y);
            transform.getValues(this.mMatrixValuesFrom);
            this.mScaleTypeTo.getTransform(transform, boundsTo, childWidth, childHeight, this.mFocusPointTo == null ? focusX : this.mFocusPointTo.x, this.mFocusPointTo == null ? focusY : this.mFocusPointTo.y);
            transform.getValues(this.mMatrixValuesTo);
            for (int i = 0; i < 9; ++i) {
                this.mMatrixValuesInterpolated[i] = this.mMatrixValuesFrom[i] * (1.0f - this.mInterpolatingValue) + this.mMatrixValuesTo[i] * this.mInterpolatingValue;
            }
            transform.setValues(this.mMatrixValuesInterpolated);
            return transform;
        }

        public String toString() {
            return String.format("InterpolatingScaleType(%s (%s) -> %s (%s))", String.valueOf(this.mScaleTypeFrom), String.valueOf(this.mFocusPointFrom), String.valueOf(this.mScaleTypeTo), String.valueOf(this.mFocusPointTo));
        }
    }

    public static interface StatefulScaleType {
        public Object getState();
    }

    private static class ScaleTypeFitY
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitY();

        private ScaleTypeFitY() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = scaleY;
            float dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale) * 0.5f;
            float dy = parentRect.top;
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "fit_y";
        }
    }

    private static class ScaleTypeFitX
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitX();

        private ScaleTypeFitX() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = scaleX;
            float dx = parentRect.left;
            float dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale) * 0.5f;
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "fit_x";
        }
    }

    private static class ScaleTypeFocusCrop
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFocusCrop();

        private ScaleTypeFocusCrop() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float dy;
            float dx;
            float scale;
            if (scaleY > scaleX) {
                scale = scaleY;
                dx = (float)parentRect.width() * 0.5f - (float)childWidth * scale * focusX;
                dx = (float)parentRect.left + Math.max(Math.min(dx, 0.0f), (float)parentRect.width() - (float)childWidth * scale);
                dy = parentRect.top;
            } else {
                scale = scaleX;
                dx = parentRect.left;
                dy = (float)parentRect.height() * 0.5f - (float)childHeight * scale * focusY;
                dy = (float)parentRect.top + Math.max(Math.min(dy, 0.0f), (float)parentRect.height() - (float)childHeight * scale);
            }
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "focus_crop";
        }
    }

    private static class ScaleTypeCenterCrop
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeCenterCrop();

        private ScaleTypeCenterCrop() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float dy;
            float dx;
            float scale;
            if (scaleY > scaleX) {
                scale = scaleY;
                dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale) * 0.5f;
                dy = parentRect.top;
            } else {
                scale = scaleX;
                dx = parentRect.left;
                dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale) * 0.5f;
            }
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "center_crop";
        }
    }

    private static class ScaleTypeCenterInside
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeCenterInside();

        private ScaleTypeCenterInside() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = Math.min(Math.min(scaleX, scaleY), 1.0f);
            float dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale) * 0.5f;
            float dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale) * 0.5f;
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "center_inside";
        }
    }

    private static class ScaleTypeCenter
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeCenter();

        private ScaleTypeCenter() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float dx = (float)parentRect.left + (float)(parentRect.width() - childWidth) * 0.5f;
            float dy = (float)parentRect.top + (float)(parentRect.height() - childHeight) * 0.5f;
            outTransform.setTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "center";
        }
    }

    private static class ScaleTypeFitEnd
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitEnd();

        private ScaleTypeFitEnd() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = Math.min(scaleX, scaleY);
            float dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale);
            float dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale);
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "fit_end";
        }
    }

    private static class ScaleTypeFitCenter
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitCenter();

        private ScaleTypeFitCenter() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = Math.min(scaleX, scaleY);
            float dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale) * 0.5f;
            float dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale) * 0.5f;
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "fit_center";
        }
    }

    private static class ScaleTypeFitBottomStart
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitBottomStart();

        private ScaleTypeFitBottomStart() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = Math.min(scaleX, scaleY);
            float dx = parentRect.left;
            float dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale);
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "fit_bottom_start";
        }
    }

    private static class ScaleTypeFitStart
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitStart();

        private ScaleTypeFitStart() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float scale = Math.min(scaleX, scaleY);
            float dx = parentRect.left;
            float dy = parentRect.top;
            outTransform.setScale(scale, scale);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "fit_start";
        }
    }

    private static class ScaleTypeFitXY
    extends AbstractScaleType {
        public static final ScaleType INSTANCE = new ScaleTypeFitXY();

        private ScaleTypeFitXY() {
        }

        @Override
        public void getTransformImpl(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY, float scaleX, float scaleY) {
            float dx = parentRect.left;
            float dy = parentRect.top;
            outTransform.setScale(scaleX, scaleY);
            outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        }

        public String toString() {
            return "fit_xy";
        }
    }

    public static abstract class AbstractScaleType
    implements ScaleType {
        @Override
        public Matrix getTransform(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY) {
            float sX = (float)parentRect.width() / (float)childWidth;
            float sY = (float)parentRect.height() / (float)childHeight;
            this.getTransformImpl(outTransform, parentRect, childWidth, childHeight, focusX, focusY, sX, sY);
            return outTransform;
        }

        public abstract void getTransformImpl(Matrix var1, Rect var2, int var3, int var4, float var5, float var6, float var7, float var8);
    }

    public static interface ScaleType {
        public static final ScaleType FIT_XY = ScaleTypeFitXY.INSTANCE;
        public static final ScaleType FIT_X = ScaleTypeFitX.INSTANCE;
        public static final ScaleType FIT_Y = ScaleTypeFitY.INSTANCE;
        public static final ScaleType FIT_START = ScaleTypeFitStart.INSTANCE;
        public static final ScaleType FIT_CENTER = ScaleTypeFitCenter.INSTANCE;
        public static final ScaleType FIT_END = ScaleTypeFitEnd.INSTANCE;
        public static final ScaleType CENTER = ScaleTypeCenter.INSTANCE;
        public static final ScaleType CENTER_INSIDE = ScaleTypeCenterInside.INSTANCE;
        public static final ScaleType CENTER_CROP = ScaleTypeCenterCrop.INSTANCE;
        public static final ScaleType FOCUS_CROP = ScaleTypeFocusCrop.INSTANCE;
        public static final ScaleType FIT_BOTTOM_START = ScaleTypeFitBottomStart.INSTANCE;

        public Matrix getTransform(Matrix var1, Rect var2, int var3, int var4, float var5, float var6);
    }
}

