/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.drawee.drawable.CloneableDrawable;
import com.facebook.drawee.drawable.DrawableUtils;
import com.facebook.drawee.drawable.ForwardingDrawable;

public class AutoRotateDrawable
extends ForwardingDrawable
implements Runnable,
CloneableDrawable {
    private static final int DEGREES_IN_FULL_ROTATION = 360;
    private static final int FRAME_INTERVAL_MS = 20;
    private int mInterval;
    private boolean mClockwise;
    @VisibleForTesting
    float mRotationAngle = 0.0f;
    private boolean mIsScheduled = false;

    public AutoRotateDrawable(Drawable drawable, int interval) {
        this(drawable, interval, true);
    }

    public AutoRotateDrawable(Drawable drawable, int interval, boolean clockwise) {
        super((Drawable)Preconditions.checkNotNull((Object)drawable));
        this.mInterval = interval;
        this.mClockwise = clockwise;
    }

    public void reset() {
        this.mRotationAngle = 0.0f;
        this.mIsScheduled = false;
        this.unscheduleSelf(this);
        this.invalidateSelf();
    }

    public void setClockwise(boolean clockwise) {
        this.mClockwise = clockwise;
    }

    @Override
    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        Rect bounds = this.getBounds();
        int width = bounds.right - bounds.left;
        int height = bounds.bottom - bounds.top;
        float angle = this.mRotationAngle;
        if (!this.mClockwise) {
            angle = 360.0f - this.mRotationAngle;
        }
        canvas.rotate(angle, (float)(bounds.left + width / 2), (float)(bounds.top + height / 2));
        super.draw(canvas);
        canvas.restoreToCount(saveCount);
        this.scheduleNextFrame();
    }

    @Override
    public void run() {
        this.mIsScheduled = false;
        this.mRotationAngle += (float)this.getIncrement();
        this.invalidateSelf();
    }

    @Override
    public AutoRotateDrawable cloneDrawable() {
        Drawable delegateCopy = DrawableUtils.cloneDrawable(this.getDrawable());
        return new AutoRotateDrawable(delegateCopy, this.mInterval, this.mClockwise);
    }

    private void scheduleNextFrame() {
        if (!this.mIsScheduled) {
            this.mIsScheduled = true;
            this.scheduleSelf(this, SystemClock.uptimeMillis() + 20L);
        }
    }

    private int getIncrement() {
        return (int)(20.0f / (float)this.mInterval * 360.0f);
    }
}

