/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class OrientedDrawable
extends ForwardingDrawable {
    @VisibleForTesting
    final Matrix mRotationMatrix;
    private int mRotationAngle;
    private int mExifOrientation;
    private final Matrix mTempMatrix = new Matrix();
    private final RectF mTempRectF = new RectF();

    public OrientedDrawable(Drawable drawable, int rotationAngle) {
        this(drawable, rotationAngle, 0);
    }

    public OrientedDrawable(Drawable drawable, int rotationAngle, int exifOrientation) {
        super(drawable);
        this.mRotationMatrix = new Matrix();
        this.mRotationAngle = rotationAngle - rotationAngle % 90;
        this.mExifOrientation = exifOrientation >= 0 && exifOrientation <= 8 ? exifOrientation : 0;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mRotationAngle <= 0 && (this.mExifOrientation == 0 || this.mExifOrientation == 1)) {
            super.draw(canvas);
            return;
        }
        int saveCount = canvas.save();
        canvas.concat(this.mRotationMatrix);
        super.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    @Override
    public int getIntrinsicWidth() {
        if (this.mExifOrientation == 5 || this.mExifOrientation == 7 || this.mRotationAngle % 180 != 0) {
            return super.getIntrinsicHeight();
        }
        return super.getIntrinsicWidth();
    }

    @Override
    public int getIntrinsicHeight() {
        if (this.mExifOrientation == 5 || this.mExifOrientation == 7 || this.mRotationAngle % 180 != 0) {
            return super.getIntrinsicWidth();
        }
        return super.getIntrinsicHeight();
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        Drawable underlyingDrawable = this.getCurrent();
        if (underlyingDrawable == null) {
            return;
        }
        if (this.mRotationAngle > 0 || this.mExifOrientation != 0 && this.mExifOrientation != 1) {
            switch (this.mExifOrientation) {
                case 2: {
                    this.mRotationMatrix.setScale(-1.0f, 1.0f);
                    break;
                }
                case 4: {
                    this.mRotationMatrix.setScale(1.0f, -1.0f);
                    break;
                }
                case 5: {
                    this.mRotationMatrix.setRotate(270.0f, (float)bounds.centerX(), (float)bounds.centerY());
                    this.mRotationMatrix.postScale(1.0f, -1.0f);
                    break;
                }
                case 7: {
                    this.mRotationMatrix.setRotate(270.0f, (float)bounds.centerX(), (float)bounds.centerY());
                    this.mRotationMatrix.postScale(-1.0f, 1.0f);
                    break;
                }
                default: {
                    this.mRotationMatrix.setRotate((float)this.mRotationAngle, (float)bounds.centerX(), (float)bounds.centerY());
                }
            }
            this.mTempMatrix.reset();
            this.mRotationMatrix.invert(this.mTempMatrix);
            this.mTempRectF.set(bounds);
            this.mTempMatrix.mapRect(this.mTempRectF);
            underlyingDrawable.setBounds((int)this.mTempRectF.left, (int)this.mTempRectF.top, (int)this.mTempRectF.right, (int)this.mTempRectF.bottom);
        } else {
            underlyingDrawable.setBounds(bounds);
        }
    }

    @Override
    public void getTransform(Matrix transform) {
        this.getParentTransform(transform);
        if (!this.mRotationMatrix.isIdentity()) {
            transform.preConcat(this.mRotationMatrix);
        }
    }
}

