/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.drawable;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Objects;
import com.facebook.drawee.drawable.ForwardingDrawable;
import com.facebook.drawee.drawable.ScalingUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B%\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0014\u0010 \u001a\u0004\u0018\u00010\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.H\u0014J\b\u0010/\u001a\u00020)H\u0002J\b\u00100\u001a\u00020)H\u0007J\u0010\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020\u001dH\u0016R$\u0010\u000b\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\rR\u001a\u0010\u0015\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\rR\u0018\u0010\u0017\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\rR\u0018\u0010\u001a\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\rR\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001e\u0010\rR\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u000f\"\u0004\b#\u0010\u0011R(\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00063"}, d2={"Lcom/facebook/drawee/drawable/ScaleTypeDrawable;", "Lcom/facebook/drawee/drawable/ForwardingDrawable;", "drawable", "Landroid/graphics/drawable/Drawable;", "scaleType", "Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;", "<init>", "(Landroid/graphics/drawable/Drawable;Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;)V", "focusPoint", "Landroid/graphics/PointF;", "(Landroid/graphics/drawable/Drawable;Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;Landroid/graphics/PointF;)V", "mScaleType", "getMScaleType$annotations", "()V", "getMScaleType", "()Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;", "setMScaleType", "(Lcom/facebook/drawee/drawable/ScalingUtils$ScaleType;)V", "mScaleTypeState", "", "getMScaleTypeState$annotations", "mFocusPoint", "getMFocusPoint$annotations", "mUnderlyingWidth", "", "getMUnderlyingWidth$annotations", "mUnderlyingHeight", "getMUnderlyingHeight$annotations", "mDrawMatrix", "Landroid/graphics/Matrix;", "getMDrawMatrix$annotations", "tempMatrix", "setCurrent", "newDelegate", "getScaleType", "setScaleType", "getFocusPoint", "()Landroid/graphics/PointF;", "setFocusPoint", "(Landroid/graphics/PointF;)V", "draw", "", "canvas", "Landroid/graphics/Canvas;", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "configureBoundsIfUnderlyingChanged", "configureBounds", "getTransform", "transform", "drawee_release"})
public final class ScaleTypeDrawable
extends ForwardingDrawable {
    @NotNull
    private ScalingUtils.ScaleType mScaleType;
    @JvmField
    @Nullable
    public Object mScaleTypeState;
    @JvmField
    @Nullable
    public PointF mFocusPoint;
    @JvmField
    public int mUnderlyingWidth;
    @JvmField
    public int mUnderlyingHeight;
    @JvmField
    @Nullable
    public Matrix mDrawMatrix;
    @NotNull
    private final Matrix tempMatrix;

    @NotNull
    public final ScalingUtils.ScaleType getMScaleType() {
        return this.mScaleType;
    }

    public final void setMScaleType(@NotNull ScalingUtils.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"<set-?>");
        this.mScaleType = scaleType;
    }

    @VisibleForTesting
    public static /* synthetic */ void getMScaleType$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getMScaleTypeState$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getMFocusPoint$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getMUnderlyingWidth$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getMUnderlyingHeight$annotations() {
    }

    @VisibleForTesting
    public static /* synthetic */ void getMDrawMatrix$annotations() {
    }

    public ScaleTypeDrawable(@Nullable Drawable drawable, @NotNull ScalingUtils.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        super(drawable);
        this.tempMatrix = new Matrix();
        this.mScaleType = scaleType;
    }

    public ScaleTypeDrawable(@Nullable Drawable drawable, @NotNull ScalingUtils.ScaleType scaleType, @Nullable PointF focusPoint) {
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        super(drawable);
        this.tempMatrix = new Matrix();
        this.mScaleType = scaleType;
        this.mFocusPoint = focusPoint;
    }

    @Override
    @Nullable
    public Drawable setCurrent(@Nullable Drawable newDelegate) {
        Drawable previousDelegate = super.setCurrent(newDelegate);
        this.configureBounds();
        return previousDelegate;
    }

    @NotNull
    public final ScalingUtils.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public final void setScaleType(@NotNull ScalingUtils.ScaleType scaleType) {
        Intrinsics.checkNotNullParameter((Object)scaleType, (String)"scaleType");
        if (Objects.equal((Object)this.mScaleType, (Object)scaleType)) {
            return;
        }
        this.mScaleType = scaleType;
        this.mScaleTypeState = null;
        this.configureBounds();
        this.invalidateSelf();
    }

    @Nullable
    public final PointF getFocusPoint() {
        return this.mFocusPoint;
    }

    public final void setFocusPoint(@Nullable PointF focusPoint) {
        if (Objects.equal((Object)this.mFocusPoint, (Object)focusPoint)) {
            return;
        }
        if (focusPoint == null) {
            this.mFocusPoint = null;
        } else {
            if (this.mFocusPoint == null) {
                this.mFocusPoint = new PointF();
            }
            PointF pointF = this.mFocusPoint;
            Intrinsics.checkNotNull((Object)pointF);
            pointF.set(focusPoint);
        }
        this.configureBounds();
        this.invalidateSelf();
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.configureBoundsIfUnderlyingChanged();
        if (this.mDrawMatrix != null) {
            int saveCount = canvas.save();
            canvas.clipRect(this.getBounds());
            canvas.concat(this.mDrawMatrix);
            super.draw(canvas);
            canvas.restoreToCount(saveCount);
        } else {
            super.draw(canvas);
        }
    }

    @Override
    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.configureBounds();
    }

    private final void configureBoundsIfUnderlyingChanged() {
        boolean underlyingChanged;
        boolean scaleTypeChanged = false;
        if (this.mScaleType instanceof ScalingUtils.StatefulScaleType) {
            ScalingUtils.ScaleType scaleType = this.mScaleType;
            Intrinsics.checkNotNull((Object)scaleType, (String)"null cannot be cast to non-null type com.facebook.drawee.drawable.ScalingUtils.StatefulScaleType");
            Object object = ((ScalingUtils.StatefulScaleType)scaleType).getState();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getState(...)");
            Object state = object;
            scaleTypeChanged = !Intrinsics.areEqual((Object)state, (Object)this.mScaleTypeState);
            this.mScaleTypeState = state;
        }
        Drawable drawable = this.getCurrent();
        if (drawable == null) {
            return;
        }
        Drawable current = drawable;
        boolean bl = underlyingChanged = this.mUnderlyingWidth != current.getIntrinsicWidth() || this.mUnderlyingHeight != current.getIntrinsicHeight();
        if (underlyingChanged || scaleTypeChanged) {
            this.configureBounds();
        }
    }

    @VisibleForTesting
    public final void configureBounds() {
        float f;
        float f2;
        Drawable underlyingDrawable = this.getCurrent();
        if (underlyingDrawable == null) {
            this.mUnderlyingWidth = this.mUnderlyingHeight = 0;
            this.mDrawMatrix = null;
            return;
        }
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
        Rect bounds = rect;
        int viewWidth = bounds.width();
        int viewHeight = bounds.height();
        int underlyingWidth = this.mUnderlyingWidth = underlyingDrawable.getIntrinsicWidth();
        int underlyingHeight = this.mUnderlyingHeight = underlyingDrawable.getIntrinsicHeight();
        if (underlyingWidth <= 0 || underlyingHeight <= 0) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
            return;
        }
        if (underlyingWidth == viewWidth && underlyingHeight == viewHeight) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
            return;
        }
        if (this.mScaleType == ScalingUtils.ScaleType.FIT_XY) {
            underlyingDrawable.setBounds(bounds);
            this.mDrawMatrix = null;
            return;
        }
        underlyingDrawable.setBounds(0, 0, underlyingWidth, underlyingHeight);
        this.tempMatrix.reset();
        if (this.mFocusPoint != null) {
            PointF pointF = this.mFocusPoint;
            Intrinsics.checkNotNull((Object)pointF);
            f2 = pointF.x;
        } else {
            f2 = 0.5f;
        }
        if (this.mFocusPoint != null) {
            PointF pointF = this.mFocusPoint;
            Intrinsics.checkNotNull((Object)pointF);
            f = pointF.y;
        } else {
            f = 0.5f;
        }
        this.mScaleType.getTransform(this.tempMatrix, bounds, underlyingWidth, underlyingHeight, f2, f);
        this.mDrawMatrix = this.tempMatrix;
    }

    @Override
    public void getTransform(@NotNull Matrix transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        this.getParentTransform(transform);
        this.configureBoundsIfUnderlyingChanged();
        if (this.mDrawMatrix != null) {
            transform.preConcat(this.mDrawMatrix);
        }
    }
}

