/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.generic;

import androidx.annotation.ColorInt;
import com.facebook.common.internal.Preconditions;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Arrays;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class RoundingParams {
    private RoundingMethod mRoundingMethod = RoundingMethod.BITMAP_ONLY;
    private boolean mRoundAsCircle = false;
    @Nullable
    private float[] mCornersRadii = null;
    private int mOverlayColor = 0;
    private float mBorderWidth = 0.0f;
    private int mBorderColor = 0;
    private float mPadding = 0.0f;
    private boolean mScaleDownInsideBorders = false;
    private boolean mPaintFilterBitmap = false;
    private boolean mRepeatEdgePixels = false;

    public RoundingParams setRoundAsCircle(boolean roundAsCircle) {
        this.mRoundAsCircle = roundAsCircle;
        return this;
    }

    public boolean getRoundAsCircle() {
        return this.mRoundAsCircle;
    }

    public RoundingParams setRepeatEdgePixels(boolean repeatEdgePixels) {
        this.mRepeatEdgePixels = repeatEdgePixels;
        return this;
    }

    public boolean getRepeatEdgePixels() {
        return this.mRepeatEdgePixels;
    }

    public RoundingParams setCornersRadius(float radius) {
        Arrays.fill(this.getOrCreateRoundedCornersRadii(), radius);
        return this;
    }

    public RoundingParams setCornersRadii(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        float[] radii = this.getOrCreateRoundedCornersRadii();
        radii[0] = radii[1] = topLeft;
        radii[2] = radii[3] = topRight;
        radii[4] = radii[5] = bottomRight;
        radii[6] = radii[7] = bottomLeft;
        return this;
    }

    public RoundingParams setCornersRadii(float[] radii) {
        Preconditions.checkNotNull((Object)radii);
        Preconditions.checkArgument((radii.length == 8 ? 1 : 0) != 0, (Object)"radii should have exactly 8 values");
        System.arraycopy(radii, 0, this.getOrCreateRoundedCornersRadii(), 0, 8);
        return this;
    }

    @Nullable
    public float[] getCornersRadii() {
        return this.mCornersRadii;
    }

    public RoundingParams setRoundingMethod(RoundingMethod roundingMethod) {
        this.mRoundingMethod = roundingMethod;
        return this;
    }

    public RoundingMethod getRoundingMethod() {
        return this.mRoundingMethod;
    }

    public RoundingParams setOverlayColor(@ColorInt int overlayColor) {
        this.mOverlayColor = overlayColor;
        this.mRoundingMethod = RoundingMethod.OVERLAY_COLOR;
        return this;
    }

    public int getOverlayColor() {
        return this.mOverlayColor;
    }

    private float[] getOrCreateRoundedCornersRadii() {
        if (this.mCornersRadii == null) {
            this.mCornersRadii = new float[8];
        }
        return this.mCornersRadii;
    }

    public static RoundingParams asCircle() {
        return new RoundingParams().setRoundAsCircle(true);
    }

    public static RoundingParams fromCornersRadius(float radius) {
        return new RoundingParams().setCornersRadius(radius);
    }

    public static RoundingParams fromCornersRadii(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        return new RoundingParams().setCornersRadii(topLeft, topRight, bottomRight, bottomLeft);
    }

    public static RoundingParams fromCornersRadii(float[] radii) {
        return new RoundingParams().setCornersRadii(radii);
    }

    public RoundingParams setBorderWidth(float width) {
        Preconditions.checkArgument((width >= 0.0f ? 1 : 0) != 0, (Object)"the border width cannot be < 0");
        this.mBorderWidth = width;
        return this;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public RoundingParams setBorderColor(@ColorInt int color) {
        this.mBorderColor = color;
        return this;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public RoundingParams setBorder(@ColorInt int color, float width) {
        Preconditions.checkArgument((width >= 0.0f ? 1 : 0) != 0, (Object)"the border width cannot be < 0");
        this.mBorderWidth = width;
        this.mBorderColor = color;
        return this;
    }

    public RoundingParams setPadding(float padding) {
        Preconditions.checkArgument((padding >= 0.0f ? 1 : 0) != 0, (Object)"the padding cannot be < 0");
        this.mPadding = padding;
        return this;
    }

    public float getPadding() {
        return this.mPadding;
    }

    public RoundingParams setScaleDownInsideBorders(boolean scaleDownInsideBorders) {
        this.mScaleDownInsideBorders = scaleDownInsideBorders;
        return this;
    }

    public boolean getScaleDownInsideBorders() {
        return this.mScaleDownInsideBorders;
    }

    public RoundingParams setPaintFilterBitmap(boolean paintFilterBitmap) {
        this.mPaintFilterBitmap = paintFilterBitmap;
        return this;
    }

    public boolean getPaintFilterBitmap() {
        return this.mPaintFilterBitmap;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoundingParams that = (RoundingParams)o;
        if (this.mRoundAsCircle != that.mRoundAsCircle) {
            return false;
        }
        if (this.mOverlayColor != that.mOverlayColor) {
            return false;
        }
        if (Float.compare(that.mBorderWidth, this.mBorderWidth) != 0) {
            return false;
        }
        if (this.mBorderColor != that.mBorderColor) {
            return false;
        }
        if (Float.compare(that.mPadding, this.mPadding) != 0) {
            return false;
        }
        if (this.mRoundingMethod != that.mRoundingMethod) {
            return false;
        }
        if (this.mScaleDownInsideBorders != that.mScaleDownInsideBorders) {
            return false;
        }
        if (this.mPaintFilterBitmap != that.mPaintFilterBitmap) {
            return false;
        }
        return Arrays.equals(this.mCornersRadii, that.mCornersRadii);
    }

    public int hashCode() {
        int result = this.mRoundingMethod != null ? this.mRoundingMethod.hashCode() : 0;
        result = 31 * result + (this.mRoundAsCircle ? 1 : 0);
        result = 31 * result + (this.mCornersRadii != null ? Arrays.hashCode(this.mCornersRadii) : 0);
        result = 31 * result + this.mOverlayColor;
        result = 31 * result + (this.mBorderWidth != 0.0f ? Float.floatToIntBits(this.mBorderWidth) : 0);
        result = 31 * result + this.mBorderColor;
        result = 31 * result + (this.mPadding != 0.0f ? Float.floatToIntBits(this.mPadding) : 0);
        result = 31 * result + (this.mScaleDownInsideBorders ? 1 : 0);
        result = 31 * result + (this.mPaintFilterBitmap ? 1 : 0);
        return result;
    }

    public static enum RoundingMethod {
        OVERLAY_COLOR,
        BITMAP_ONLY;

    }
}

