/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drawee.gestures;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import androidx.annotation.VisibleForTesting;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class GestureDetector {
    @Nullable
    @VisibleForTesting
    ClickListener mClickListener;
    @VisibleForTesting
    final float mSingleTapSlopPx;
    @VisibleForTesting
    boolean mIsCapturingGesture;
    @VisibleForTesting
    boolean mIsClickCandidate;
    @VisibleForTesting
    long mActionDownTime;
    @VisibleForTesting
    float mActionDownX;
    @VisibleForTesting
    float mActionDownY;

    public GestureDetector(Context context) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mSingleTapSlopPx = viewConfiguration.getScaledTouchSlop();
        this.init();
    }

    public static GestureDetector newInstance(Context context) {
        return new GestureDetector(context);
    }

    public void init() {
        this.mClickListener = null;
        this.reset();
    }

    public void reset() {
        this.mIsCapturingGesture = false;
        this.mIsClickCandidate = false;
    }

    public void setClickListener(ClickListener clickListener) {
        this.mClickListener = clickListener;
    }

    public boolean isCapturingGesture() {
        return this.mIsCapturingGesture;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mIsCapturingGesture = true;
                this.mIsClickCandidate = true;
                this.mActionDownTime = event.getEventTime();
                this.mActionDownX = event.getX();
                this.mActionDownY = event.getY();
                break;
            }
            case 2: {
                if (!(Math.abs(event.getX() - this.mActionDownX) > this.mSingleTapSlopPx) && !(Math.abs(event.getY() - this.mActionDownY) > this.mSingleTapSlopPx)) break;
                this.mIsClickCandidate = false;
                break;
            }
            case 3: {
                this.mIsCapturingGesture = false;
                this.mIsClickCandidate = false;
                break;
            }
            case 1: {
                this.mIsCapturingGesture = false;
                if (Math.abs(event.getX() - this.mActionDownX) > this.mSingleTapSlopPx || Math.abs(event.getY() - this.mActionDownY) > this.mSingleTapSlopPx) {
                    this.mIsClickCandidate = false;
                }
                if (this.mIsClickCandidate && event.getEventTime() - this.mActionDownTime <= (long)ViewConfiguration.getLongPressTimeout() && this.mClickListener != null) {
                    this.mClickListener.onClick();
                }
                this.mIsClickCandidate = false;
            }
        }
        return true;
    }

    public static interface ClickListener {
        public boolean onClick();
    }
}

