/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.cache.disk;

import android.content.SharedPreferences;
import com.facebook.common.logging.FLog;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class DiskStorageCacheUtil {
    private static final String TAG = DiskStorageCacheUtil.class.getSimpleName();

    private DiskStorageCacheUtil() {
    }

    protected static void addDiskCacheEntry(Integer hashKey, String resourceId, SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(String.valueOf(hashKey), resourceId);
        editor.apply();
    }

    protected static void deleteDiskCacheEntry(Integer hashKey, SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(String.valueOf(hashKey));
        editor.apply();
    }

    protected static synchronized Map<Integer, String> readStoredIndex(@Nullable SharedPreferences sharedPreferences, Set<String> resourceIndex) {
        HashMap<Integer, String> index = new HashMap<Integer, String>();
        if (sharedPreferences == null) {
            return index;
        }
        Map allEntries = sharedPreferences.getAll();
        SharedPreferences.Editor editor = sharedPreferences.edit();
        for (Map.Entry entry : allEntries.entrySet()) {
            if (entry.getValue() instanceof String) {
                Integer key = Integer.parseInt((String)entry.getKey());
                if (resourceIndex.contains(entry.getValue())) {
                    index.put(key, (String)entry.getValue());
                    continue;
                }
                editor.remove(String.valueOf(entry.getKey()));
                continue;
            }
            FLog.e((String)TAG, (String)"SharedPreference doesn't store right data type");
        }
        editor.apply();
        return index;
    }

    protected static void clearDiskEntries(SharedPreferences sharedPreferences) {
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.apply();
    }
}

